/*
 * Decompiled with CFR 0.152.
 */
package com.mrbysco.armorposer.client.gui;

import com.mrbysco.armorposer.client.GlowHandler;
import com.mrbysco.armorposer.client.gui.ArmorStandScreen;
import com.mrbysco.armorposer.client.gui.widgets.ArmorGlowWidget;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ObjectSelectionList;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntitySelector;
import net.minecraft.world.entity.decoration.ArmorStand;

public class ArmorGlowScreen
extends Screen {
    private static final int PADDING = 6;
    private ArmorGlowWidget armorListWidget;
    private ArmorGlowWidget.ListEntry selected = null;
    private final List<ArmorStand> armorStands;
    private Button locateButton;
    private Button modifyButton;
    public ArmorStandScreen parentScreen;

    public ArmorGlowScreen(ArmorStandScreen parent) {
        super((Component)Component.translatable((String)"armorposer.gui.armor_list.list"));
        this.parentScreen = parent;
        this.minecraft = Minecraft.getInstance();
        if (this.minecraft.player == null) {
            this.onClose();
        }
        List armorStands = this.minecraft.level.getEntitiesOfClass(ArmorStand.class, this.minecraft.player.getBoundingBox().inflate(30.0), EntitySelector.LIVING_ENTITY_STILL_ALIVE).stream().collect(Collectors.toList());
        armorStands.sort((armorStand, armorStand2) -> {
            double distance1 = armorStand.distanceToSqr((Entity)this.minecraft.player);
            double distance2 = armorStand2.distanceToSqr((Entity)this.minecraft.player);
            return Double.compare(distance1, distance2);
        });
        this.armorStands = Collections.unmodifiableList(armorStands);
    }

    public boolean isPauseScreen() {
        return false;
    }

    protected void init() {
        int centerWidth = this.width / 2;
        int listWidth = this.width / 4 + 20;
        int structureWidth = this.width - listWidth - 18;
        int closeButtonWidth = Math.min(structureWidth, 160);
        int y = this.height - 20 - 6;
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.cancel"), b -> this.onClose()).bounds(centerWidth - closeButtonWidth / 2 + 6, y, closeButtonWidth, 20).build());
        int buttonWidth = closeButtonWidth / 2 - 1;
        this.locateButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.locate"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                GlowHandler.startGlowing(this.selected.getArmorStand().getUUID());
                this.minecraft.player.lookAt(EntityAnchorArgument.Anchor.EYES, this.selected.getArmorStand().position());
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6, y -= 24, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.locateButton);
        this.modifyButton = Button.builder((Component)Component.translatable((String)"armorposer.gui.armor_list.modify"), b -> {
            if (this.selected != null && this.minecraft.player != null) {
                this.minecraft.setScreen((Screen)new ArmorStandScreen(this.selected.getArmorStand()));
            }
        }).bounds(centerWidth - closeButtonWidth / 2 + 6 + buttonWidth + 2, y, buttonWidth, 20).build();
        this.addRenderableWidget((GuiEventListener)this.modifyButton);
        int fullButtonHeight = 32;
        MutableComponent mutableComponent = Component.translatable((String)"armorposer.gui.armor_list.list");
        Objects.requireNonNull(this.getScreenFont());
        this.armorListWidget = new ArmorGlowWidget(this, (Component)mutableComponent, listWidth, fullButtonHeight, 14 - 9);
        this.armorListWidget.setX(0);
        this.armorListWidget.setY(10);
        this.armorListWidget.setHeight(this.height);
        this.addWidget((GuiEventListener)this.armorListWidget);
        this.updateCache();
    }

    public void tick() {
        this.armorListWidget.setSelected((AbstractSelectionList.Entry)this.selected);
    }

    public <T extends ObjectSelectionList.Entry<T>> void buildPositionList(Consumer<T> ListViewConsumer, Function<ArmorStand, T> newEntry) {
        this.armorStands.forEach(stand -> ListViewConsumer.accept((ObjectSelectionList.Entry)newEntry.apply((ArmorStand)stand)));
    }

    public void render(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
        this.armorListWidget.render(guiGraphics, mouseX, mouseY, partialTicks);
        super.render(guiGraphics, mouseX, mouseY, partialTicks);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    public void renderBackground(GuiGraphics guiGraphics, int mouseX, int mouseY, float partialTicks) {
    }

    public void setSelected(ArmorGlowWidget.ListEntry entry) {
        this.selected = entry == this.selected ? null : entry;
        this.updateCache();
    }

    private void updateCache() {
        this.locateButton.active = this.selected != null;
        this.modifyButton.active = this.selected != null;
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public void resize(Minecraft mc, int width, int height) {
        ArmorGlowWidget.ListEntry selected = this.selected;
        this.init(mc, width, height);
        this.selected = selected;
        this.updateCache();
    }

    public void onClose() {
        this.minecraft.setScreen((Screen)this.parentScreen);
    }

    public Minecraft getScreenMinecraft() {
        return this.minecraft;
    }

    public Font getScreenFont() {
        return this.font;
    }
}

