/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.tile;

import codechicken.lib.inventory.container.CCLMenuType;
import codechicken.lib.vec.Vector3;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.core.block.ProjectRedBlock;
import mrtjp.projectred.core.init.CoreBlocks;
import mrtjp.projectred.core.init.CoreItems;
import mrtjp.projectred.core.inventory.BaseContainer;
import mrtjp.projectred.core.inventory.container.ElectrotineGeneratorMenu;
import mrtjp.projectred.core.power.ILowLoadMachine;
import mrtjp.projectred.core.power.ILowLoadPowerLine;
import mrtjp.projectred.core.power.PowerConductor;
import mrtjp.projectred.core.tile.BasePoweredBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.SimpleMenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.neoforged.neoforge.items.IItemHandler;
import net.neoforged.neoforge.items.wrapper.InvWrapper;

public class ElectrotineGeneratorBlockEntity
extends BasePoweredBlockEntity
implements ILowLoadMachine {
    protected final PowerConductor conductor = new PowerConductor(this, 0.01, 160.0);
    private int chargeFlow = 0;
    private final ElectrotineGeneratorInventory inventory = new ElectrotineGeneratorInventory();
    private final IItemHandler handler = new InvWrapper((Container)this.inventory);
    private int burnTimeRemaining = 0;
    private int powerStored = 0;

    public ElectrotineGeneratorBlockEntity(BlockPos pos, BlockState state) {
        super(CoreBlocks.ELECTROTINE_GENERATOR_BLOCK_ENTITY.get(), pos, state);
    }

    @Override
    public void saveToNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.saveToNBT(tag, lookupProvider);
        this.conductor.save(tag);
        this.inventory.saveTo(tag, "inventory", lookupProvider);
        tag.putInt("burnTime", this.burnTimeRemaining);
        tag.putInt("stored", this.powerStored);
    }

    @Override
    public void loadFromNBT(CompoundTag tag, HolderLookup.Provider lookupProvider) {
        super.loadFromNBT(tag, lookupProvider);
        this.conductor.load(tag);
        this.inventory.loadFrom(tag, "inventory", lookupProvider);
        this.burnTimeRemaining = tag.getInt("burnTime");
        this.powerStored = tag.getInt("stored");
    }

    @Override
    public BlockState storeBlockState(BlockState defaultState) {
        return (BlockState)((BlockState)super.storeBlockState(defaultState).setValue((Property)ProjectRedBlock.CHARGED, (Comparable)Boolean.valueOf(this.canConductorWork()))).setValue((Property)ProjectRedBlock.WORKING, (Comparable)Boolean.valueOf(this.burnTimeRemaining > 0));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack itemStack, Player player, InteractionHand hand, BlockHitResult hit) {
        if (!this.getLevel().isClientSide) {
            CCLMenuType.openMenu((ServerPlayer)((ServerPlayer)player), (MenuProvider)new SimpleMenuProvider((id, inv, p) -> new ElectrotineGeneratorMenu(inv, this, id), (Component)this.getBlockState().getBlock().getName()), p -> p.writePos(this.getBlockPos()));
        }
        return ItemInteractionResult.sidedSuccess((boolean)this.getLevel().isClientSide);
    }

    @Override
    public void onBlockRemoved() {
        super.onBlockRemoved();
        ElectrotineGeneratorBlockEntity.dropInventory((Container)this.inventory, this.getLevel(), Vector3.fromBlockPos((BlockPos)this.getBlockPos()));
    }

    @Override
    public void tick() {
        if (this.getLevel().isClientSide) {
            return;
        }
        this.conductor.tick();
        this.chargeFlow <<= 1;
        if (this.canConductorWork()) {
            this.chargeFlow |= 1;
        }
        this.tryBurnDust();
        this.tryChargeStorage();
        this.tryChargeConductor();
        if (this.level.getGameTime() % 10L == 0L) {
            this.updateRendersIfNeeded();
        }
    }

    @Override
    public PowerConductor getConductor(int dir) {
        return this.conductor;
    }

    @Override
    public boolean canConnectPart(IConnectable part, int s, int edgeRot) {
        if (part instanceof ILowLoadPowerLine) {
            return true;
        }
        return part instanceof ILowLoadMachine;
    }

    private void tryBurnDust() {
        ItemStack removedDust;
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining < this.getBurnUseOnCharge() && !(removedDust = this.inventory.removeItem(0, 1)).isEmpty()) {
            int addedBurnTime = this.getBurnTimeForDust(removedDust);
            this.burnTimeRemaining = Math.min(this.getMaxBurnTime(), this.burnTimeRemaining + addedBurnTime);
        }
    }

    private void tryChargeStorage() {
        if (this.burnTimeRemaining == 0) {
            return;
        }
        if (this.powerStored < this.getMaxStorage() && this.burnTimeRemaining >= this.getBurnUseOnCharge()) {
            ++this.powerStored;
            this.burnTimeRemaining -= this.getBurnUseOnCharge();
        } else {
            this.burnTimeRemaining -= Math.min(this.burnTimeRemaining, this.getBurnUseOnIdle());
        }
    }

    private void tryChargeConductor() {
        if (this.getConductorCharge() < this.getDrawFloor() && this.powerStored > 0) {
            int n = Math.min(this.getDrawFloor() - this.getConductorCharge(), this.getDrawSpeed()) / 10;
            n = Math.min(n, this.powerStored);
            this.conductor.applyPower(n * 1000);
            this.powerStored -= n;
        }
    }

    private void updateRendersIfNeeded() {
        boolean lastWorking = (Boolean)this.getBlockState().getValue((Property)ProjectRedBlock.WORKING);
        boolean lastCharged = (Boolean)this.getBlockState().getValue((Property)ProjectRedBlock.CHARGED);
        boolean isWorking = this.burnTimeRemaining > 0;
        boolean isCharged = this.canConductorWork();
        if (lastWorking != isWorking || lastCharged != isCharged) {
            this.pushBlockState();
        }
    }

    protected int getBurnTimeForDust(ItemStack dust) {
        return 2750;
    }

    public int getBurnUseOnCharge() {
        return 10;
    }

    public int getBurnUseOnIdle() {
        return 1;
    }

    public int getDrawSpeed() {
        return 100;
    }

    public int getDrawFloor() {
        return 1200;
    }

    public int getMaxStorage() {
        return 800;
    }

    public int getMaxBurnTime() {
        return 2750;
    }

    @Override
    public int getConductorCharge() {
        return (int)(this.conductor.getVoltage() * 10.0);
    }

    @Override
    public int getConductorFlow() {
        return this.chargeFlow;
    }

    @Override
    public boolean canConductorWork() {
        return this.getConductorCharge() > 600;
    }

    public IItemHandler getHandler() {
        return this.handler;
    }

    public SimpleContainer getInventory() {
        return this.inventory;
    }

    public int getBurnTimeRemaining() {
        return this.burnTimeRemaining;
    }

    public int getPowerStored() {
        return this.powerStored;
    }

    private static class ElectrotineGeneratorInventory
    extends BaseContainer {
        public ElectrotineGeneratorInventory() {
            super(1);
        }

        public boolean canPlaceItem(int slot, ItemStack stack) {
            return stack.getItem() == CoreItems.ELECTROTINE_DUST_ITEM.get();
        }
    }
}

