/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.part;

import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;

public interface IOrientableFacePart {
    public int getSide();

    public int getRotation();

    public void setSide(int var1);

    public void setRotation(int var1);

    default public Transformation rotationT() {
        return Rotation.sideOrientation((int)this.getSide(), (int)this.getRotation()).at(Vector3.CENTER);
    }

    default public void onOrientationChange() {
    }

    default public int toInternal(int absRot) {
        return (absRot + 6 - this.getRotation()) % 4;
    }

    default public int toAbsolute(int r) {
        return (r + this.getRotation() + 2) % 4;
    }

    default public int absoluteDir(int absRot) {
        return Rotation.rotateSide((int)this.getSide(), (int)absRot);
    }

    default public int absoluteRot(int absDir) {
        return Rotation.rotationTo((int)this.getSide(), (int)absDir);
    }

    default public int toInternalMask(int mask) {
        return IOrientableFacePart.shiftMask(mask, this.toInternal(0));
    }

    default public int toAbsoluteMask(int mask) {
        return IOrientableFacePart.shiftMask(mask, this.toAbsolute(0));
    }

    public static int shiftMask(int mask, int r) {
        return mask & 0xFFFFFFF0 | (mask << r | mask >> 4 - r) & 0xF;
    }

    public static int flipMaskZ(int mask) {
        return mask & 5 | mask << 2 & 8 | mask >> 2 & 2;
    }
}

