/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client.particle;

import mrtjp.projectred.core.client.particle.BaseActionParticle;
import mrtjp.projectred.core.client.particle.ParticleAction;

public class SequenceAction
extends ParticleAction {
    private final ParticleAction[] actions;
    private int index = 0;

    public SequenceAction(ParticleAction ... actions) {
        this.actions = actions;
    }

    @Override
    public void tick() {
        super.tick();
        if (this.index < this.actions.length) {
            this.actions[this.index].tick();
        }
    }

    @Override
    public void operate(BaseActionParticle particle, float partialTick) {
        super.operate(particle, partialTick);
        if (this.actions[this.index].isFinished()) {
            ++this.index;
            if (this.index >= this.actions.length) {
                this.finished = true;
                return;
            }
            this.actions[this.index].beginAction(particle);
        }
        if (this.index < this.actions.length) {
            this.actions[this.index].operate(particle, partialTick);
        }
    }

    @Override
    public ParticleAction copy() {
        ParticleAction[] newActions = new ParticleAction[this.actions.length];
        for (int i = 0; i < this.actions.length; ++i) {
            newActions[i] = this.actions[i].copy();
        }
        return new SequenceAction(newActions);
    }

    @Override
    public void beginAction(BaseActionParticle particle) {
        this.index = 0;
        this.actions[this.index].beginAction(particle);
    }

    @Override
    public void operateAction(BaseActionParticle particle, double time) {
    }
}

