/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client.particle;

import java.util.LinkedList;
import javax.annotation.Nullable;
import mrtjp.projectred.core.client.particle.ParticleAction;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.particle.Particle;

public abstract class BaseActionParticle
extends Particle {
    private final LinkedList<ParticleAction> actionQueue = new LinkedList();
    @Nullable
    private ParticleAction currentAction = null;

    public BaseActionParticle(ClientLevel pLevel, double pX, double pY, double pZ) {
        super(pLevel, pX, pY, pZ);
    }

    public void addAction(ParticleAction action) {
        this.actionQueue.add(action);
    }

    protected void tickActions() {
        if (this.currentAction != null) {
            this.currentAction.tick();
        }
    }

    protected void runActions(float partialTick) {
        if (this.currentAction == null && !this.actionQueue.isEmpty()) {
            this.currentAction = this.actionQueue.poll();
            this.currentAction.reset();
            this.currentAction.beginAction(this);
        }
        if (this.currentAction != null) {
            this.currentAction.operate(this, partialTick);
            if (this.currentAction.isFinished()) {
                this.currentAction = null;
            }
        }
    }

    public void tick() {
        super.tick();
        this.tickActions();
    }

    public float getAlpha() {
        return this.alpha;
    }

    public void setAlpha(float alpha) {
        this.alpha = alpha;
    }
}

