/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.core.client;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.pipeline.RenderTarget;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import mrtjp.projectred.core.ProjectRedCore;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.PostChain;
import net.minecraft.client.renderer.PostPass;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.packs.resources.ResourceManager;
import net.minecraft.server.packs.resources.ResourceProvider;
import org.joml.Matrix4f;

public class FixedScalePostChain
extends PostChain {
    private final Map<String, Double> fixedRenderTargetScales = new HashMap<String, Double>();

    public FixedScalePostChain(TextureManager textureManager, ResourceManager resourceManager, RenderTarget renderTarget, ResourceLocation location) throws IOException, JsonSyntaxException {
        super(textureManager, (ResourceProvider)resourceManager, renderTarget, location);
    }

    public FixedScalePostChain(ResourceLocation location) throws IOException {
        this(Minecraft.getInstance().getTextureManager(), Minecraft.getInstance().getResourceManager(), Minecraft.getInstance().getMainRenderTarget(), location);
    }

    public FixedScalePostChain(String modId, String filename) throws IOException {
        this(ResourceLocation.fromNamespaceAndPath((String)modId, (String)("shaders/post/" + filename + ".json")));
    }

    public void addFixedTargetScale(String name, double scale) {
        this.fixedRenderTargetScales.put(name, scale);
    }

    public void resizeIfNeeded() {
        if (this.screenWidth != this.screenTarget.width || this.screenHeight != this.screenTarget.height) {
            this.resize(this.screenTarget.width, this.screenTarget.height);
        }
    }

    public void resize(int newWidth, int newHeight) {
        ProjectRedCore.LOGGER.debug("Resizing FixedScalePostChain from {}x{} to {}x{}", (Object)this.screenWidth, (Object)this.screenHeight, (Object)newWidth, (Object)newHeight);
        super.resize(newWidth, newHeight);
        for (Map.Entry<String, Double> entry : this.fixedRenderTargetScales.entrySet()) {
            String name = entry.getKey();
            Double scale = entry.getValue();
            RenderTarget target = (RenderTarget)this.customRenderTargets.get(name);
            int newTargetWidth = (int)Math.ceil((double)newWidth * scale);
            int newTargetHeight = (int)Math.ceil((double)newHeight * scale);
            ProjectRedCore.LOGGER.debug("Resizing target {} from {}x{} to {}x{}", (Object)entry.getKey(), (Object)target.width, (Object)target.height, (Object)newTargetWidth, (Object)newTargetHeight);
            target.resize(newTargetWidth, newTargetHeight, Minecraft.ON_OSX);
        }
        for (PostPass pass : this.passes) {
            Matrix4f orthoMatrix = new Matrix4f().setOrtho(0.0f, (float)pass.inTarget.width, 0.0f, (float)pass.inTarget.height, 0.1f, 1000.0f);
            pass.setOrthoMatrix(orthoMatrix);
        }
    }
}

