/*
 * Decompiled with CFR 0.152.
 */
package net.Gabou.gaboulibs.util;

import dev.architectury.platform.Platform;
import java.util.HashSet;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompatUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger((String)"CompatUtils");
    private static final Set<String> INCOMPATIBLE_TYPES = new HashSet<String>();

    public static boolean isBlacklistedEntityType(String id) {
        if (id == null) {
            return false;
        }
        if (INCOMPATIBLE_TYPES.contains(id)) {
            return true;
        }
        return id.contains("dragonmounts");
    }

    public static void markIncompatibleEntityType(String id) {
        if (id != null) {
            INCOMPATIBLE_TYPES.add(id);
            LOGGER.warn("Marked incompatible entity type {}", (Object)id);
        }
    }

    public static boolean isAlexsMobsLoaded() {
        return Platform.isModLoaded((String)"alexsmobs");
    }

    public static boolean isNaturalistLoaded() {
        return Platform.isModLoaded((String)"naturalist");
    }
}

