/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class SycamoreTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<SycamoreTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(crabappleTrunkPlacerInstance -> SycamoreTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)crabappleTrunkPlacerInstance).apply((Applicative)crabappleTrunkPlacerInstance, SycamoreTrunkPlacer::new));

    public SycamoreTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.SYCAMORE_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        SycamoreTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.below(), (TreeConfiguration)pConfig);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageSpots = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = pFreeTreeHeight + pRandom.nextInt(this.heightRandA, this.heightRandB);
        ArrayList<Direction> directions = new ArrayList<Direction>(List.of(Direction.NORTH, Direction.SOUTH, Direction.EAST, Direction.WEST));
        if ((double)pRandom.nextFloat() > 0.5) {
            pPos = pPos.relative(Direction.SOUTH);
        }
        if ((double)pRandom.nextFloat() > 0.5) {
            pPos = pPos.relative(Direction.WEST);
        }
        for (int i = 0; i < maxHeight; ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.NORTH).above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.EAST).above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.NORTH).relative(Direction.EAST).above(i), pConfig);
        }
        foliageSpots.add(new FoliagePlacer.FoliageAttachment(pPos.above(maxHeight).north(), 0, true));
        int branches = pRandom.nextInt(1, 4);
        for (int j = 0; j < branches; ++j) {
            Direction branchDirection = (Direction)directions.get(pRandom.nextInt(0, directions.size()));
            directions.remove(branchDirection);
            if (branchDirection.equals((Object)Direction.NORTH)) {
                pPos = pPos.north();
            } else if (branchDirection.equals((Object)Direction.EAST)) {
                pPos = pPos.east();
            }
            if (branchDirection.equals((Object)Direction.NORTH) || branchDirection.equals((Object)Direction.SOUTH)) {
                if (pRandom.nextBoolean()) {
                    pPos = pPos.east();
                }
            } else if (pRandom.nextBoolean()) {
                pPos = pPos.north();
            }
            int branchHeight = pRandom.nextInt(3, maxHeight - 2);
            int branchLength = pRandom.nextInt(2, 5);
            BlockState log = (BlockState)pConfig.trunkProvider.getState(pRandom, pPos).setValue((Property)RotatedPillarBlock.AXIS, (Comparable)branchDirection.getAxis());
            BlockPos nextPos = pPos;
            int b = 0;
            while (b < branchLength) {
                nextPos = pPos.above(branchHeight).relative(branchDirection, b + 1);
                if ((double)pRandom.nextFloat() < 0.2) {
                    pBlockSetter.accept(nextPos, (BlockState)Function.identity().apply(log));
                    ++branchHeight;
                }
                pBlockSetter.accept(nextPos, (BlockState)Function.identity().apply(log));
                if (b == 0) {
                    pBlockSetter.accept(nextPos.relative(branchDirection, -1), (BlockState)Function.identity().apply(log));
                }
                if (++b != branchLength) continue;
                foliageSpots.add(new FoliagePlacer.FoliageAttachment(nextPos, 0, false));
            }
        }
        return foliageSpots;
    }
}

