/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.BiConsumer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacer;
import net.minecraft.world.level.levelgen.feature.trunkplacers.TrunkPlacerType;
import net.redchujelly.cluttered.setup.TrunkPlacerTypeRegistration;

public class RedMushroomTrunkPlacer
extends TrunkPlacer {
    public static final MapCodec<RedMushroomTrunkPlacer> CODEC = RecordCodecBuilder.mapCodec(redMushroomTrunkPlacerInstance -> RedMushroomTrunkPlacer.trunkPlacerParts((RecordCodecBuilder.Instance)redMushroomTrunkPlacerInstance).apply((Applicative)redMushroomTrunkPlacerInstance, RedMushroomTrunkPlacer::new));

    public RedMushroomTrunkPlacer(int pBaseHeight, int pHeightRandA, int pHeightRandB) {
        super(pBaseHeight, pHeightRandA, pHeightRandB);
    }

    protected TrunkPlacerType<?> type() {
        return (TrunkPlacerType)TrunkPlacerTypeRegistration.RED_MUSHROOM_TRUNK_PLACER.get();
    }

    public List<FoliagePlacer.FoliageAttachment> placeTrunk(LevelSimulatedReader pLevel, BiConsumer<BlockPos, BlockState> pBlockSetter, RandomSource pRandom, int pFreeTreeHeight, BlockPos pPos, TreeConfiguration pConfig) {
        RedMushroomTrunkPlacer.setDirtAt((LevelSimulatedReader)pLevel, pBlockSetter, (RandomSource)pRandom, (BlockPos)pPos.below(), (TreeConfiguration)pConfig);
        ArrayList<FoliagePlacer.FoliageAttachment> foliageSpots = new ArrayList<FoliagePlacer.FoliageAttachment>();
        int maxHeight = pFreeTreeHeight + pRandom.nextInt(this.heightRandA, this.heightRandB);
        if ((double)pRandom.nextFloat() > 0.5) {
            pPos = pPos.relative(Direction.SOUTH);
        }
        if ((double)pRandom.nextFloat() > 0.5) {
            pPos = pPos.relative(Direction.WEST);
        }
        for (int i = 0; i < maxHeight; ++i) {
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.NORTH).above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.EAST).above(i), pConfig);
            this.placeLog(pLevel, pBlockSetter, pRandom, pPos.relative(Direction.NORTH).relative(Direction.EAST).above(i), pConfig);
        }
        foliageSpots.add(new FoliagePlacer.FoliageAttachment(pPos.above(maxHeight).north(), 0, true));
        return foliageSpots;
    }
}

