/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class RedMushroomFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<RedMushroomFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(redMushroomFoliagePlacerInstance -> RedMushroomFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)redMushroomFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)redMushroomFoliagePlacerInstance, RedMushroomFoliagePlacer::new));
    private final int height;

    public RedMushroomFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.RED_MUSHROOM_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        float layerSize = (float)(this.height / 5) - 0.001f;
        for (int i = 0; i < this.height; ++i) {
            if ((float)i < 2.0f * layerSize) {
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos(), 1, -i, pAttachment.doubleTrunk());
                continue;
            }
            if ((float)i < 4.0f * layerSize) {
                this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos(), 2, -i, pAttachment.doubleTrunk());
                continue;
            }
            this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos(), 3, -i, pAttachment.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        float layerSize = (float)(this.height / 5) - 0.001f;
        if ((float)(-pLocalY) < 1.0f * layerSize) {
            return pLocalX == pLocalZ && pLocalX == pRange;
        }
        if ((float)(-pLocalY) < 2.0f * layerSize) {
            return false;
        }
        if ((float)(-pLocalY) < 4.0f * layerSize) {
            return pLocalX == pLocalZ && pLocalX == pRange || pLocalX <= 1 && pLocalZ <= 1;
        }
        return Math.abs(pLocalX) + Math.abs(pLocalZ) >= pRange * 2 - 1 || pLocalX <= 1 && pLocalZ <= 1;
    }
}

