/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.core.BlockPos;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class PoplarFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<PoplarFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(poplarFoliagePlacerInstance -> PoplarFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)poplarFoliagePlacerInstance).and((App)Codec.intRange((int)0, (int)16).fieldOf("height").forGetter(fp -> fp.height)).apply((Applicative)poplarFoliagePlacerInstance, PoplarFoliagePlacer::new));
    private final int height;

    public PoplarFoliagePlacer(IntProvider pRadius, IntProvider pOffset, int height) {
        super(pRadius, pOffset);
        this.height = height;
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.POPLAR_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader levelSimulatedReader, FoliagePlacer.FoliageSetter foliageSetter, RandomSource randomSource, TreeConfiguration treeConfiguration, int i, FoliagePlacer.FoliageAttachment foliageAttachment, int i1, int i2, int i3) {
        BlockPos nextPos = foliageAttachment.pos();
        int maxHeight = this.height + randomSource.nextInt(-1, 1);
        int topHeight = randomSource.nextInt(1, 3);
        for (int j = 0; j < maxHeight; ++j) {
            if (j == 0) {
                PoplarFoliagePlacer.tryPlaceLeaf((LevelSimulatedReader)levelSimulatedReader, (FoliagePlacer.FoliageSetter)foliageSetter, (RandomSource)randomSource, (TreeConfiguration)treeConfiguration, (BlockPos)nextPos.above());
            }
            int radius = 2;
            if (j < topHeight) {
                radius = 1;
            }
            if (maxHeight - j < 3) {
                radius = 1;
            }
            this.placeLeavesRow(levelSimulatedReader, foliageSetter, randomSource, treeConfiguration, nextPos, radius, 0, foliageAttachment.doubleTrunk());
            nextPos = nextPos.below();
        }
    }

    public int foliageHeight(RandomSource randomSource, int i, TreeConfiguration treeConfiguration) {
        return this.height;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean b) {
        return pLocalX == pRange && pLocalZ == pRange && (pRandom.nextInt(0, 2) == 0 || pLocalY == 0);
    }
}

