/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.worldgen.tree.custom;

import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import net.minecraft.util.RandomSource;
import net.minecraft.util.valueproviders.IntProvider;
import net.minecraft.world.level.LevelSimulatedReader;
import net.minecraft.world.level.levelgen.feature.configurations.TreeConfiguration;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacer;
import net.minecraft.world.level.levelgen.feature.foliageplacers.FoliagePlacerType;
import net.redchujelly.cluttered.setup.FoliagePlacerTypeRegistration;

public class MapleFoliagePlacer
extends FoliagePlacer {
    public static final MapCodec<MapleFoliagePlacer> CODEC = RecordCodecBuilder.mapCodec(poplarFoliagePlacerInstance -> MapleFoliagePlacer.foliagePlacerParts((RecordCodecBuilder.Instance)poplarFoliagePlacerInstance).apply((Applicative)poplarFoliagePlacerInstance, MapleFoliagePlacer::new));

    public MapleFoliagePlacer(IntProvider pRadius, IntProvider pOffset) {
        super(pRadius, pOffset);
    }

    protected FoliagePlacerType<?> type() {
        return (FoliagePlacerType)FoliagePlacerTypeRegistration.MAPLE_FOLIAGE_PLACER.get();
    }

    protected void createFoliage(LevelSimulatedReader pLevel, FoliagePlacer.FoliageSetter pBlockSetter, RandomSource pRandom, TreeConfiguration pConfig, int pMaxFreeTreeHeight, FoliagePlacer.FoliageAttachment pAttachment, int pFoliageHeight, int pFoliageRadius, int pOffset) {
        float sizeMultiplier = (float)pRandom.nextInt(100, 130) / 100.0f;
        int height = (int)(8.0f * sizeMultiplier);
        int radius = 4;
        for (int i = 0; i <= height; ++i) {
            if (i == 0) {
                radius = (int)(2.0f * sizeMultiplier);
            }
            if (i == 1) {
                radius = (int)(3.0f * sizeMultiplier);
            }
            if (i > 1) {
                radius = (int)(4.0f * sizeMultiplier);
            }
            if (i > 5) {
                radius = (int)(3.0f * sizeMultiplier);
            }
            if (i > 7) {
                radius = (int)(2.0f * sizeMultiplier);
            }
            if (i == height) {
                radius = (int)(1.0f * sizeMultiplier);
            }
            this.placeLeavesRow(pLevel, pBlockSetter, pRandom, pConfig, pAttachment.pos().above(), radius, i, pAttachment.doubleTrunk());
        }
    }

    public int foliageHeight(RandomSource pRandom, int pHeight, TreeConfiguration pConfig) {
        return 0;
    }

    protected boolean shouldSkipLocation(RandomSource pRandom, int pLocalX, int pLocalY, int pLocalZ, int pRange, boolean pLarge) {
        float radius;
        float sizeMultiplier = (float)pRandom.nextInt(90, 110) / 100.0f;
        double distance = Math.sqrt(Math.pow(pLocalX, 2.0) + Math.pow(pLocalZ, 2.0));
        return distance > (double)(radius = (float)pRange * sizeMultiplier);
    }
}

