/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class ChairEntity
extends Entity {
    private final BlockPos CHAIR_POS;
    private final Level CHAIR_LEVEL;

    public ChairEntity(EntityType<?> pEntityType, Level pLevel) {
        super(pEntityType, pLevel);
        this.CHAIR_POS = new BlockPos(0, 0, 0);
        this.CHAIR_LEVEL = pLevel;
    }

    public ChairEntity(EntityType<?> pEntityType, Level pLevel, BlockPos pos) {
        super(pEntityType, pLevel);
        this.CHAIR_POS = pos;
        this.CHAIR_LEVEL = pLevel;
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
    }

    protected void readAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void addAdditionalSaveData(CompoundTag compoundTag) {
    }

    protected void removePassenger(Entity pPassenger) {
        this.teleportTo(this.getX(), this.getY() + 0.5, this.getZ());
        super.removePassenger(pPassenger);
        this.kill();
    }

    public void kill() {
        BlockState chair = this.CHAIR_LEVEL.getBlockState(this.CHAIR_POS);
        if (chair.hasProperty((Property)BlockStateProperties.OCCUPIED)) {
            this.teleportTo(this.getX(), this.getY() + 0.5, this.getZ());
            this.CHAIR_LEVEL.setBlock(this.CHAIR_POS, (BlockState)chair.setValue((Property)BlockStateProperties.OCCUPIED, (Comparable)Boolean.valueOf(false)), 2);
        }
        super.kill();
    }

    public void dismountTo(double pX, double pY, double pZ) {
        super.dismountTo(pX, pY, pZ);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isInvisible() {
        return true;
    }

    public boolean isNoGravity() {
        return true;
    }
}

