/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class MermaidDresserBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_1 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_S_1 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_E_1 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_W_1 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_N_2 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)14.0, (double)15.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_S_2 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)14.0, (double)16.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_E_2 = Shapes.or((VoxelShape)Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)14.0, (double)15.0), (VoxelShape)SHAPE_TOP);
    private static final VoxelShape SHAPE_W_2 = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)16.0), (VoxelShape)SHAPE_TOP);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}};

    public MermaidDresserBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1) {
                    yield SHAPE_S_1;
                }
                yield SHAPE_S_2;
            }
            case Direction.EAST -> {
                if (part == 1) {
                    yield SHAPE_E_1;
                }
                yield SHAPE_E_2;
            }
            case Direction.WEST -> {
                if (part == 1) {
                    yield SHAPE_W_1;
                }
                yield SHAPE_W_2;
            }
            default -> part == 1 ? SHAPE_N_1 : SHAPE_N_2;
        };
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.SIX_ROWS_BE.get()).create(blockPos, blockState);
    }
}

