/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock.storage;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.storage.MultiblockStorage;
import net.redchujelly.cluttered.setup.TileEntityRegistration;
import org.jetbrains.annotations.Nullable;

public class CardIndexBlock
extends MultiblockStorage {
    private static final VoxelShape SHAPE_N_1 = Block.box((double)1.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_S_1 = Block.box((double)0.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_1 = Block.box((double)1.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_1 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_N_2 = Block.box((double)0.0, (double)1.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_S_2 = Block.box((double)1.0, (double)1.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_2 = Block.box((double)1.0, (double)1.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_W_2 = Block.box((double)0.0, (double)1.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_N_3 = Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_S_3 = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_3 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_W_3 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_N_4 = Block.box((double)0.0, (double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_S_4 = Block.box((double)1.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_E_4 = Block.box((double)1.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)15.0);
    private static final VoxelShape SHAPE_W_4 = Block.box((double)0.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_TOP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)4);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}, new int[][]{{3}, {4}}};

    public CardIndexBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        switch (part) {
            case 1: {
                switch (facing) {
                    case SOUTH: {
                        return SHAPE_S_1;
                    }
                    case EAST: {
                        return SHAPE_E_1;
                    }
                    case WEST: {
                        return SHAPE_W_1;
                    }
                }
                return SHAPE_N_1;
            }
            case 2: {
                switch (facing) {
                    case SOUTH: {
                        return SHAPE_S_2;
                    }
                    case EAST: {
                        return SHAPE_E_2;
                    }
                    case WEST: {
                        return SHAPE_W_2;
                    }
                }
                return SHAPE_N_2;
            }
            case 3: {
                switch (facing) {
                    case SOUTH: {
                        return Shapes.or((VoxelShape)SHAPE_S_3, (VoxelShape)SHAPE_TOP);
                    }
                    case EAST: {
                        return Shapes.or((VoxelShape)SHAPE_E_3, (VoxelShape)SHAPE_TOP);
                    }
                    case WEST: {
                        return Shapes.or((VoxelShape)SHAPE_W_3, (VoxelShape)SHAPE_TOP);
                    }
                }
                return Shapes.or((VoxelShape)SHAPE_N_3, (VoxelShape)SHAPE_TOP);
            }
        }
        switch (facing) {
            case SOUTH: {
                return Shapes.or((VoxelShape)SHAPE_S_4, (VoxelShape)SHAPE_TOP);
            }
            case EAST: {
                return Shapes.or((VoxelShape)SHAPE_E_4, (VoxelShape)SHAPE_TOP);
            }
            case WEST: {
                return Shapes.or((VoxelShape)SHAPE_W_4, (VoxelShape)SHAPE_TOP);
            }
        }
        return Shapes.or((VoxelShape)SHAPE_N_4, (VoxelShape)SHAPE_TOP);
    }

    @Override
    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        if ((Integer)blockState.getValue((Property)this.getMultiblockPart()) != 1) {
            return null;
        }
        return ((BlockEntityType)TileEntityRegistration.SIX_ROWS_BE.get()).create(blockPos, blockState);
    }
}

