/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockPlacer;

public class TableBlock
extends MultiblockPlacer {
    private static final MapCodec<TableBlock> CODEC = TableBlock.simpleCodec(TableBlock::new);
    private static final VoxelShape TOP = Block.box((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_NORTH = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH = Shapes.join((VoxelShape)Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), (VoxelShape)Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST = Shapes.join((VoxelShape)Block.box((double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)14.0, (double)4.0), (VoxelShape)Block.box((double)1.0, (double)0.0, (double)1.0, (double)4.0, (double)14.0, (double)4.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST = Shapes.join((VoxelShape)Block.box((double)1.0, (double)0.0, (double)12.0, (double)4.0, (double)14.0, (double)15.0), (VoxelShape)Block.box((double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)14.0, (double)15.0), (BooleanOp)BooleanOp.OR);
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1}, {2}}};

    @Override
    protected MapCodec<? extends Block> codec() {
        return CODEC;
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return Shapes.join((VoxelShape)(switch (facing) {
            case Direction.SOUTH -> part == 1 ? SHAPE_SOUTH : SHAPE_NORTH;
            case Direction.EAST -> part == 1 ? SHAPE_EAST : SHAPE_WEST;
            case Direction.WEST -> part == 1 ? SHAPE_WEST : SHAPE_EAST;
            default -> part == 1 ? SHAPE_NORTH : SHAPE_SOUTH;
        }), (VoxelShape)TOP, (BooleanOp)BooleanOp.OR);
    }

    public TableBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

