/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockBedBlock;

public class MushroomBedBlock
extends MultiblockBedBlock {
    private static final VoxelShape SHAPE_BASE = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)9.0, (double)16.0);
    private static final VoxelShape SHAPE_N_1 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_S_1 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)2.0));
    private static final VoxelShape SHAPE_E_1 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_W_1 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0));
    private static final VoxelShape SHAPE_N_2 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)3.0));
    private static final VoxelShape SHAPE_S_2 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)17.0, (double)16.0));
    private static final VoxelShape SHAPE_E_2 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)17.0, (double)16.0));
    private static final VoxelShape SHAPE_W_2 = Shapes.or((VoxelShape)SHAPE_BASE, (VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)17.0, (double)16.0));
    public static final IntegerProperty MULTIBLOCK_PART = IntegerProperty.create((String)"part", (int)1, (int)2);
    private static final int[][][] MULTIBLOCK_SHAPE = new int[][][]{new int[][]{{1, 2}}};

    public MushroomBedBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        if ((Integer)pState.getValue((Property)this.getMultiblockPart()) == 1) {
            return switch (facing) {
                case Direction.SOUTH -> SHAPE_S_1;
                case Direction.EAST -> SHAPE_E_1;
                case Direction.WEST -> SHAPE_W_1;
                default -> SHAPE_N_1;
            };
        }
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_S_2;
            case Direction.EAST -> SHAPE_E_2;
            case Direction.WEST -> SHAPE_W_2;
            default -> SHAPE_N_2;
        };
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            return InteractionResult.CONSUME;
        }
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        if (part == 1 && !(pState = pLevel.getBlockState(pPos = pPos.relative((Direction)pState.getValue((Property)FACING)))).is((Block)this)) {
            return InteractionResult.CONSUME;
        }
        if (!MushroomBedBlock.canSetSpawn(pLevel)) {
            pLevel.removeBlock(pPos, false);
            BlockPos removePos = pPos.relative(((Direction)pState.getValue((Property)FACING)).getOpposite());
            if (pLevel.getBlockState(removePos).is((Block)this)) {
                pLevel.removeBlock(removePos, false);
            }
            Vec3 center = pPos.getCenter();
            pLevel.explode(null, pLevel.damageSources().badRespawnPointExplosion(center), null, center, 5.0f, true, Level.ExplosionInteraction.BLOCK);
        } else {
            if (((Boolean)pState.getValue((Property)OCCUPIED)).booleanValue()) {
                pPlayer.displayClientMessage((Component)Component.translatable((String)"block.minecraft.bed.occupied"), true);
                return InteractionResult.SUCCESS;
            }
            pPlayer.startSleepInBed(pPos).ifLeft(sleepingProblem -> {
                if (sleepingProblem.getMessage() != null) {
                    pPlayer.displayClientMessage(sleepingProblem.getMessage(), true);
                }
            });
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public IntegerProperty getMultiblockPart() {
        return MULTIBLOCK_PART;
    }

    @Override
    public int[][][] getMultiblockShape() {
        return MULTIBLOCK_SHAPE;
    }
}

