/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.multiblock;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.multiblock.MultiblockChair;
import net.redchujelly.cluttered.entity.ChairEntity;
import net.redchujelly.cluttered.setup.EntityTypeRegistration;

public class ArmchairBlock
extends MultiblockChair {
    private static final float SEAT_Y_OFFSET = 0.675f;
    private static final VoxelShape SHAPE_NORTH_2 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)10.0, (double)0.0, (double)14.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)0.0, (double)13.0, (double)17.0, (double)4.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_NORTH_1 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)10.0, (double)0.0, (double)8.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)3.0, (double)10.0, (double)0.0, (double)16.0, (double)17.0, (double)4.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_1 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)8.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)12.0, (double)10.0, (double)3.0, (double)16.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_2 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)17.0, (double)14.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)12.0, (double)10.0, (double)0.0, (double)16.0, (double)17.0, (double)13.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_1 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)12.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)8.0, (double)10.0, (double)0.0, (double)14.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)12.0, (double)13.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_2 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)4.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)2.0, (double)10.0, (double)0.0, (double)8.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)3.0, (double)10.0, (double)12.0, (double)16.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_1 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)10.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)17.0, (double)14.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)0.0, (double)4.0, (double)17.0, (double)13.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_2 = Shapes.join((VoxelShape)Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)10.0, (double)16.0), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)2.0, (double)16.0, (double)17.0, (double)8.0), (BooleanOp)BooleanOp.OR), (VoxelShape)Block.box((double)0.0, (double)10.0, (double)3.0, (double)4.0, (double)17.0, (double)16.0), (BooleanOp)BooleanOp.OR);

    public ArmchairBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!((Boolean)pState.getValue((Property)OCCUPIED)).booleanValue() && !pPlayer.isShiftKeyDown()) {
            if (!pLevel.isClientSide) {
                BlockPos otherHalf = this.getOtherHalfPos(pState, pPos);
                boolean otherHalfReal = pLevel.getBlockState(otherHalf).is(this.asBlock());
                float[] seatOffset = this.getSeatXZOffset(pState, pPos);
                pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 2);
                if (otherHalfReal) {
                    pLevel.setBlock(otherHalf, (BlockState)pLevel.getBlockState(otherHalf).setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(true)), 2);
                }
                ChairEntity seat = new ChairEntity((EntityType)EntityTypeRegistration.CHAIR_ENTITY.get(), pLevel, pPos);
                seat.setPos((float)pPos.getX() + 0.5f + seatOffset[0], (float)(pPos.getY() - 1) + this.getSeatOffset(), (float)pPos.getZ() + 0.5f + seatOffset[1]);
                pLevel.addFreshEntity((Entity)seat);
                pPlayer.startRiding((Entity)seat);
            }
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        BlockPos otherHalfPos = this.getOtherHalfPos(pState, pCurrentPos);
        if (pNeighborState.getBlock().equals(this.asBlock()) && !((Boolean)pNeighborState.getValue((Property)OCCUPIED)).booleanValue() && pNeighborPos.equals((Object)otherHalfPos)) {
            pLevel.setBlock(pCurrentPos, (BlockState)pState.setValue((Property)OCCUPIED, (Comparable)Boolean.valueOf(false)), 2);
        }
        return super.updateShape(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int part = (Integer)pState.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (part == 1) {
                    yield SHAPE_SOUTH_1;
                }
                yield SHAPE_SOUTH_2;
            }
            case Direction.EAST -> {
                if (part == 1) {
                    yield SHAPE_EAST_1;
                }
                yield SHAPE_EAST_2;
            }
            case Direction.WEST -> {
                if (part == 1) {
                    yield SHAPE_WEST_1;
                }
                yield SHAPE_WEST_2;
            }
            default -> part == 1 ? SHAPE_NORTH_1 : SHAPE_NORTH_2;
        };
    }

    private BlockPos getOtherHalfPos(BlockState state1, BlockPos pos1) {
        int part = (Integer)state1.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)state1.getValue((Property)FACING);
        if (facing.equals((Object)Direction.NORTH)) {
            return part == 1 ? pos1.east() : pos1.west();
        }
        if (facing.equals((Object)Direction.EAST)) {
            return part == 1 ? pos1.south() : pos1.north();
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            return part == 1 ? pos1.west() : pos1.east();
        }
        return part == 1 ? pos1.north() : pos1.south();
    }

    @Override
    public float getSeatOffset() {
        return 0.675f;
    }

    private float[] getSeatXZOffset(BlockState state1, BlockPos pos1) {
        float[] fArray;
        int part = (Integer)state1.getValue((Property)this.getMultiblockPart());
        Direction facing = (Direction)state1.getValue((Property)FACING);
        if (facing.equals((Object)Direction.NORTH)) {
            float[] fArray2;
            if (part == 1) {
                float[] fArray3 = new float[2];
                fArray3[0] = 0.5f;
                fArray2 = fArray3;
                fArray3[1] = 0.0f;
            } else {
                float[] fArray4 = new float[2];
                fArray4[0] = -0.5f;
                fArray2 = fArray4;
                fArray4[1] = 0.0f;
            }
            return fArray2;
        }
        if (facing.equals((Object)Direction.EAST)) {
            float[] fArray5;
            if (part == 1) {
                float[] fArray6 = new float[2];
                fArray6[0] = 0.0f;
                fArray5 = fArray6;
                fArray6[1] = 0.5f;
            } else {
                float[] fArray7 = new float[2];
                fArray7[0] = 0.0f;
                fArray5 = fArray7;
                fArray7[1] = -0.5f;
            }
            return fArray5;
        }
        if (facing.equals((Object)Direction.SOUTH)) {
            float[] fArray8;
            if (part == 1) {
                float[] fArray9 = new float[2];
                fArray9[0] = -0.5f;
                fArray8 = fArray9;
                fArray9[1] = 0.0f;
            } else {
                float[] fArray10 = new float[2];
                fArray10[0] = 0.5f;
                fArray8 = fArray10;
                fArray10[1] = 0.0f;
            }
            return fArray8;
        }
        if (part == 1) {
            float[] fArray11 = new float[2];
            fArray11[0] = 0.0f;
            fArray = fArray11;
            fArray11[1] = -0.5f;
        } else {
            float[] fArray12 = new float[2];
            fArray12[0] = 0.0f;
            fArray = fArray12;
            fArray12[1] = 0.5f;
        }
        return fArray;
    }
}

