/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.entity;

import net.minecraft.core.BlockPos;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ChestMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.entity.ContainerOpenersCounter;
import net.minecraft.world.level.block.entity.RandomizableContainerBlockEntity;
import net.minecraft.world.level.block.state.BlockState;

public class CustomStorageBlockEntity
extends RandomizableContainerBlockEntity {
    private NonNullList<ItemStack> items;
    private final int size;
    private final ContainerOpenersCounter openersCounter;

    public CustomStorageBlockEntity(BlockEntityType<?> pType, final BlockPos pPos, BlockState pBlockState, int rows) {
        super(pType, pPos, pBlockState);
        this.size = rows * 9;
        this.items = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        this.openersCounter = new ContainerOpenersCounter(this){

            protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, SoundEvents.BARREL_OPEN, SoundSource.BLOCKS);
            }

            protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, SoundEvents.BARREL_CLOSE, SoundSource.BLOCKS);
            }

            protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            }

            protected boolean isOwnContainer(Player player) {
                return false;
            }
        };
    }

    public CustomStorageBlockEntity(BlockEntityType<?> pType, final BlockPos pPos, BlockState pBlockState, int rows, final SoundEvent openSound, final SoundEvent closeSound) {
        super(pType, pPos, pBlockState);
        this.size = rows * 9;
        this.items = NonNullList.withSize((int)this.size, (Object)ItemStack.EMPTY);
        this.openersCounter = new ContainerOpenersCounter(this){

            protected void onOpen(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, openSound, SoundSource.BLOCKS);
            }

            protected void onClose(Level level, BlockPos blockPos, BlockState blockState) {
                level.playSound(null, pPos, closeSound, SoundSource.BLOCKS);
            }

            protected void openerCountChanged(Level level, BlockPos blockPos, BlockState blockState, int i, int i1) {
            }

            protected boolean isOwnContainer(Player player) {
                return false;
            }
        };
    }

    public NonNullList<ItemStack> getItems() {
        return this.items;
    }

    protected void setItems(NonNullList<ItemStack> pItems) {
        this.items = pItems;
    }

    protected void saveAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.saveAdditional(tag, registries);
        if (!this.trySaveLootTable(tag)) {
            ContainerHelper.saveAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    protected void loadAdditional(CompoundTag tag, HolderLookup.Provider registries) {
        super.loadAdditional(tag, registries);
        this.items = NonNullList.withSize((int)this.getContainerSize(), (Object)ItemStack.EMPTY);
        if (!this.tryLoadLootTable(tag)) {
            ContainerHelper.loadAllItems((CompoundTag)tag, this.items, (HolderLookup.Provider)registries);
        }
    }

    public void startOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.incrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    public void stopOpen(Player pPlayer) {
        if (!this.remove && !pPlayer.isSpectator()) {
            this.openersCounter.decrementOpeners(pPlayer, this.getLevel(), this.getBlockPos(), this.getBlockState());
        }
    }

    protected Component getDefaultName() {
        return Component.translatable((String)"cluttered.storage");
    }

    protected AbstractContainerMenu createMenu(int pId, Inventory pInventory) {
        return switch (this.size / 9) {
            case 1 -> new ChestMenu(MenuType.GENERIC_9x1, pId, pInventory, (Container)this, this.size / 9);
            case 2 -> new ChestMenu(MenuType.GENERIC_9x2, pId, pInventory, (Container)this, this.size / 9);
            case 4 -> new ChestMenu(MenuType.GENERIC_9x4, pId, pInventory, (Container)this, this.size / 9);
            case 5 -> new ChestMenu(MenuType.GENERIC_9x5, pId, pInventory, (Container)this, this.size / 9);
            case 6 -> ChestMenu.sixRows((int)pId, (Inventory)pInventory, (Container)this);
            default -> ChestMenu.threeRows((int)pId, (Inventory)pInventory, (Container)this);
        };
    }

    public int getContainerSize() {
        return this.size;
    }
}

