/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.FlintAndSteelItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class ShelfCandleBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)6.5, (double)0.0, (double)10.5, (double)9.5, (double)3.0, (double)13.5);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)6.5, (double)0.0, (double)2.5, (double)9.5, (double)3.0, (double)5.5);
    private static final VoxelShape SHAPE_EAST = Block.box((double)2.5, (double)0.0, (double)6.5, (double)5.5, (double)3.0, (double)9.5);
    private static final VoxelShape SHAPE_WEST = Block.box((double)10.5, (double)0.0, (double)6.5, (double)13.5, (double)3.0, (double)9.5);
    private static final Vec3 PARTICLE_OFFSET_N = new Vec3(0.5, 0.25, 0.75);
    private static final Vec3 PARTICLE_OFFSET_S = new Vec3(0.5, 0.25, 0.25);
    private static final Vec3 PARTICLE_OFFSET_E = new Vec3(0.25, 0.25, 0.5);
    private static final Vec3 PARTICLE_OFFSET_W = new Vec3(0.75, 0.25, 0.5);
    public static final BooleanProperty LIT = BlockStateProperties.LIT;

    public ShelfCandleBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Boolean)state.getValue((Property)LIT) != false ? 10 : 0;
    }

    protected ItemInteractionResult useItemOn(ItemStack stack, BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hitResult) {
        if (!((Boolean)state.getValue((Property)LIT)).booleanValue() && !((Boolean)state.getValue((Property)BlockStateProperties.WATERLOGGED)).booleanValue() && stack.getItem() instanceof FlintAndSteelItem) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(true)), 2);
                level.playSound(null, pos, SoundEvents.FLINTANDSTEEL_USE, SoundSource.BLOCKS);
                if (stack.isDamageableItem()) {
                    stack.hurtAndBreak(1, (LivingEntity)player, LivingEntity.getSlotForHand((InteractionHand)hand));
                }
            }
            return ItemInteractionResult.SUCCESS;
        }
        return super.useItemOn(stack, state, level, pos, player, hand, hitResult);
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (((Boolean)state.getValue((Property)LIT)).booleanValue()) {
            if (!level.isClientSide) {
                level.setBlock(pos, (BlockState)state.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
                level.playSound(null, pos, SoundEvents.CANDLE_EXTINGUISH, SoundSource.BLOCKS);
            }
            return InteractionResult.SUCCESS;
        }
        return super.useWithoutItem(state, level, pos, player, hitResult);
    }

    public void animateTick(BlockState pState, Level pLevel, BlockPos pPos, RandomSource pRandom) {
        if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
            Vec3 offset = this.getOffset(pState);
            float random = pRandom.nextFloat();
            if (random < 0.3f) {
                pLevel.addParticle((ParticleOptions)ParticleTypes.SMOKE, (double)pPos.getX() + offset.x, (double)pPos.getY() + offset.y, (double)pPos.getZ() + offset.z, 0.0, 0.0, 0.0);
                if (random < 0.17f) {
                    pLevel.playSound(null, pPos, SoundEvents.CANDLE_AMBIENT, SoundSource.BLOCKS, 1.0f + pRandom.nextFloat(), pRandom.nextFloat() * 0.7f + 0.3f);
                }
            }
            pLevel.addParticle((ParticleOptions)ParticleTypes.SMALL_FLAME, (double)pPos.getX() + offset.x, (double)pPos.getY() + offset.y, (double)pPos.getZ() + offset.z, 0.0, 0.0, 0.0);
        }
    }

    private Vec3 getOffset(BlockState state) {
        return switch ((Direction)state.getValue((Property)FACING)) {
            case Direction.SOUTH -> PARTICLE_OFFSET_S;
            case Direction.EAST -> PARTICLE_OFFSET_E;
            case Direction.WEST -> PARTICLE_OFFSET_W;
            default -> PARTICLE_OFFSET_N;
        };
    }

    public boolean placeLiquid(LevelAccessor pLevel, BlockPos pPos, BlockState pState, FluidState pFluidState) {
        if (!((Boolean)pState.getValue((Property)WATERLOGGED)).booleanValue() && pFluidState.getType() == Fluids.WATER) {
            BlockState waterState = (BlockState)pState.setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(true));
            if (((Boolean)pState.getValue((Property)LIT)).booleanValue()) {
                pLevel.setBlock(pPos, (BlockState)waterState.setValue((Property)LIT, (Comparable)Boolean.valueOf(false)), 2);
            } else {
                pLevel.setBlock(pPos, waterState, 3);
            }
            pLevel.scheduleTick(pPos, pFluidState.getType(), pFluidState.getType().getTickDelay((LevelReader)pLevel));
            return true;
        }
        return false;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{LIT});
    }
}

