/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class RubiksCubeBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)4.0, (double)0.0, (double)6.0, (double)12.0, (double)7.0, (double)14.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)4.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)10.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)6.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)12.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)2.0, (double)0.0, (double)4.0, (double)10.0, (double)7.0, (double)12.0);
    public static final BooleanProperty SOLVED = BooleanProperty.create((String)"solved");

    public RubiksCubeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.getStateDefinition().any()).setValue((Property)SOLVED, (Comparable)Boolean.valueOf(true)));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!pLevel.isClientSide && pState.hasProperty((Property)SOLVED)) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)SOLVED, (Comparable)Boolean.valueOf((Boolean)pState.getValue((Property)SOLVED) == false)), 2);
            pLevel.playSound(null, pPos, SoundEvents.ARMOR_STAND_BREAK, SoundSource.BLOCKS);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{SOLVED});
    }
}

