/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class MushroomTVBlock
extends SmallFurnitureBlock {
    public static final IntegerProperty CHANNEL = IntegerProperty.create((String)"channel", (int)0, (int)4);
    private static final VoxelShape SHAPE_NORTH = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)6.0, (double)14.0, (double)7.0, (double)12.0), (VoxelShape)Block.box((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0));
    private static final VoxelShape SHAPE_SOUTH = Shapes.or((VoxelShape)Block.box((double)2.0, (double)0.0, (double)4.0, (double)14.0, (double)7.0, (double)10.0), (VoxelShape)Block.box((double)0.0, (double)7.0, (double)4.0, (double)16.0, (double)16.0, (double)12.0));
    private static final VoxelShape SHAPE_EAST = Shapes.or((VoxelShape)Block.box((double)4.0, (double)0.0, (double)2.0, (double)10.0, (double)7.0, (double)14.0), (VoxelShape)Block.box((double)4.0, (double)7.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));
    private static final VoxelShape SHAPE_WEST = Shapes.or((VoxelShape)Block.box((double)6.0, (double)0.0, (double)2.0, (double)12.0, (double)7.0, (double)14.0), (VoxelShape)Block.box((double)4.0, (double)7.0, (double)0.0, (double)12.0, (double)16.0, (double)16.0));

    public MushroomTVBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)CHANNEL, (Comparable)Integer.valueOf(0)));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return switch (facing) {
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
            default -> SHAPE_NORTH;
        };
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean isWaterlogged = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged))).setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection());
    }

    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return (Integer)state.getValue((Property)CHANNEL) == 0 ? 0 : 6;
    }

    public boolean hasAnalogOutputSignal(BlockState pState) {
        return true;
    }

    public int getAnalogOutputSignal(BlockState pState, Level pLevel, BlockPos pPos) {
        return (Integer)pState.getValue((Property)CHANNEL) * 3;
    }

    private void updateNeighbors(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!pLevel.isClientSide) {
            int channel = (Integer)pState.getValue((Property)CHANNEL);
            channel = channel < 4 ? ++channel : 0;
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)CHANNEL, (Comparable)Integer.valueOf(channel)), 10);
            pLevel.playSound(null, pPos, SoundEvents.STONE_BUTTON_CLICK_ON, SoundSource.BLOCKS);
            this.updateNeighbors(pState, pLevel, pPos);
        }
        return InteractionResult.SUCCESS;
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            this.updateNeighbors(pState, pLevel, pPos);
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{CHANNEL});
    }
}

