/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import com.mojang.serialization.MapCodec;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.FaceAttachedHorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.FlatDirectionalBlock;

public class MiniFlagBlock
extends FlatDirectionalBlock {
    private static final MapCodec<MiniFlagBlock> CODEC = MiniFlagBlock.simpleCodec(MiniFlagBlock::new);
    private static final VoxelShape SHAPE_UP = Block.box((double)3.5, (double)0.0, (double)3.5, (double)12.5, (double)13.0, (double)12.5);
    private static final VoxelShape SHAPE_DOWN = Block.box((double)3.5, (double)3.0, (double)3.5, (double)12.5, (double)16.0, (double)12.5);
    private static final VoxelShape SHAPE_NORTH = Block.box((double)3.5, (double)3.5, (double)3.0, (double)12.5, (double)12.5, (double)16.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)3.5, (double)3.5, (double)0.0, (double)12.5, (double)12.5, (double)13.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)0.0, (double)3.5, (double)3.5, (double)13.0, (double)12.5, (double)12.5);
    private static final VoxelShape SHAPE_WEST = Block.box((double)3.0, (double)3.5, (double)3.5, (double)16.0, (double)12.5, (double)12.5);

    public MiniFlagBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    @Override
    protected MapCodec<? extends FaceAttachedHorizontalDirectionalBlock> codec() {
        return CODEC;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = MiniFlagBlock.getConnectedDirection((BlockState)pState);
        return switch (facing) {
            default -> throw new MatchException(null, null);
            case Direction.UP -> SHAPE_UP;
            case Direction.DOWN -> SHAPE_DOWN;
            case Direction.NORTH -> SHAPE_NORTH;
            case Direction.SOUTH -> SHAPE_SOUTH;
            case Direction.EAST -> SHAPE_EAST;
            case Direction.WEST -> SHAPE_WEST;
        };
    }
}

