/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class JamJarsBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH = Block.box((double)1.0, (double)0.0, (double)11.0, (double)15.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)5.25, (double)5.0);
    private static final VoxelShape SHAPE_EAST = Block.box((double)1.0, (double)0.0, (double)1.0, (double)5.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_WEST = Block.box((double)11.0, (double)0.0, (double)1.0, (double)15.0, (double)5.25, (double)15.0);
    private static final VoxelShape SHAPE_NORTH_STACK = Block.box((double)3.5, (double)0.0, (double)11.0, (double)12.5, (double)10.5, (double)15.0);
    private static final VoxelShape SHAPE_SOUTH_STACK = Block.box((double)3.5, (double)0.0, (double)1.0, (double)12.5, (double)10.5, (double)5.0);
    private static final VoxelShape SHAPE_EAST_STACK = Block.box((double)1.0, (double)0.0, (double)3.5, (double)5.0, (double)10.5, (double)12.5);
    private static final VoxelShape SHAPE_WEST_STACK = Block.box((double)11.0, (double)0.0, (double)3.5, (double)15.0, (double)10.5, (double)12.5);
    public static final BooleanProperty STACKED = BooleanProperty.create((String)"stacked");

    public JamJarsBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (!pLevel.isClientSide) {
            boolean stacked = (Boolean)pState.getValue((Property)STACKED);
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)STACKED, (Comparable)Boolean.valueOf(!stacked)), 2);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        boolean stacked = (Boolean)pState.getValue((Property)STACKED);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (stacked) {
                    yield SHAPE_SOUTH_STACK;
                }
                yield SHAPE_SOUTH;
            }
            case Direction.EAST -> {
                if (stacked) {
                    yield SHAPE_EAST_STACK;
                }
                yield SHAPE_EAST;
            }
            case Direction.WEST -> {
                if (stacked) {
                    yield SHAPE_WEST_STACK;
                }
                yield SHAPE_WEST;
            }
            default -> stacked ? SHAPE_NORTH_STACK : SHAPE_NORTH;
        };
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{STACKED});
    }
}

