/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.LanternPlaceState;
import net.redchujelly.cluttered.block.custom.furniture.SmallLampBlock;

public class HoppinParkLantern
extends SmallLampBlock {
    public static final EnumProperty<LanternPlaceState> PLACE_STATE = EnumProperty.create((String)"place_state", LanternPlaceState.class);
    private static final VoxelShape LANTERN_SHAPE = Shapes.or((VoxelShape)Block.box((double)5.0, (double)0.0, (double)5.0, (double)11.0, (double)11.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)8.0, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.box((double)7.0, (double)11.0, (double)7.0, (double)9.0, (double)13.0, (double)9.0)});
    private static final VoxelShape LANTERN_SHAPE_UP = Shapes.or((VoxelShape)Block.box((double)5.0, (double)3.0, (double)5.0, (double)11.0, (double)14.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)11.0, (double)4.0, (double)12.0, (double)12.0, (double)12.0), Block.box((double)7.0, (double)14.0, (double)7.0, (double)9.0, (double)16.0, (double)9.0)});
    private static final VoxelShape WALL_SHAPE_N = Shapes.or((VoxelShape)Block.box((double)5.0, (double)5.0, (double)0.0, (double)11.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.5, (double)5.0, (double)1.0, (double)8.5, (double)14.0, (double)10.0), Block.box((double)5.0, (double)0.0, (double)6.0, (double)11.0, (double)11.0, (double)12.0), Block.box((double)4.0, (double)8.0, (double)5.0, (double)12.0, (double)9.0, (double)13.0)});
    private static final VoxelShape WALL_SHAPE_S = Shapes.or((VoxelShape)Block.box((double)5.0, (double)5.0, (double)15.0, (double)11.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.5, (double)5.0, (double)6.0, (double)8.5, (double)14.0, (double)15.0), Block.box((double)5.0, (double)0.0, (double)4.0, (double)11.0, (double)11.0, (double)10.0), Block.box((double)4.0, (double)8.0, (double)3.0, (double)12.0, (double)9.0, (double)11.0)});
    private static final VoxelShape WALL_SHAPE_E = Shapes.or((VoxelShape)Block.box((double)15.0, (double)5.0, (double)5.0, (double)16.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)6.0, (double)5.0, (double)7.5, (double)15.0, (double)14.0, (double)8.5), Block.box((double)4.0, (double)0.0, (double)5.0, (double)10.0, (double)11.0, (double)11.0), Block.box((double)3.0, (double)8.0, (double)4.0, (double)11.0, (double)9.0, (double)12.0)});
    private static final VoxelShape WALL_SHAPE_W = Shapes.or((VoxelShape)Block.box((double)0.0, (double)5.0, (double)5.0, (double)1.0, (double)15.0, (double)11.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)5.0, (double)7.5, (double)10.0, (double)14.0, (double)8.5), Block.box((double)6.0, (double)0.0, (double)5.0, (double)12.0, (double)11.0, (double)11.0), Block.box((double)5.0, (double)8.0, (double)4.0, (double)13.0, (double)9.0, (double)12.0)});

    public HoppinParkLantern(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(PLACE_STATE, (Comparable)((Object)LanternPlaceState.FLOOR)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        LanternPlaceState shouldPlaceOn;
        boolean isWaterlogged = pContext.getLevel().getFluidState(pContext.getClickedPos()).getType() == Fluids.WATER;
        Direction surface = pContext.getClickedFace();
        Direction facing = pContext.getHorizontalDirection().getOpposite();
        if (surface.equals((Object)Direction.UP)) {
            shouldPlaceOn = LanternPlaceState.FLOOR;
        } else if (surface.equals((Object)Direction.DOWN)) {
            shouldPlaceOn = LanternPlaceState.CEILING;
        } else {
            shouldPlaceOn = LanternPlaceState.WALL;
            facing = pContext.getClickedFace().getOpposite();
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(PLACE_STATE, (Comparable)((Object)shouldPlaceOn))).setValue((Property)FACING, (Comparable)facing)).setValue((Property)WATERLOGGED, (Comparable)Boolean.valueOf(isWaterlogged));
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        LanternPlaceState placedOn = (LanternPlaceState)((Object)pState.getValue(PLACE_STATE));
        if (placedOn.equals((Object)LanternPlaceState.FLOOR)) {
            return LANTERN_SHAPE;
        }
        if (placedOn.equals((Object)LanternPlaceState.CEILING)) {
            return LANTERN_SHAPE_UP;
        }
        Direction facing = (Direction)pState.getValue((Property)FACING);
        switch (facing) {
            case SOUTH: {
                return WALL_SHAPE_S;
            }
            case EAST: {
                return WALL_SHAPE_E;
            }
            case WEST: {
                return WALL_SHAPE_W;
            }
        }
        return WALL_SHAPE_N;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{PLACE_STATE});
    }
}

