/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.furniture;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallLampBlock;
import org.jetbrains.annotations.Nullable;

public class BeeLampBlock
extends SmallLampBlock {
    private static final VoxelShape SHAPE_NS = Block.box((double)4.5, (double)1.0, (double)3.0, (double)11.5, (double)8.0, (double)13.0);
    private static final VoxelShape SHAPE_EW = Block.box((double)3.0, (double)1.0, (double)4.5, (double)13.0, (double)8.0, (double)11.5);
    private final boolean redstone;

    public BeeLampBlock(BlockBehaviour.Properties pProperties, boolean isRedstone) {
        super(pProperties);
        this.redstone = isRedstone;
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return ((Direction)pState.getValue((Property)FACING)).equals((Object)Direction.NORTH) || ((Direction)pState.getValue((Property)FACING)).equals((Object)Direction.SOUTH) ? SHAPE_NS : SHAPE_EW;
    }

    public int getSignal(BlockState pState, BlockGetter pLevel, BlockPos pPos, Direction pDirection) {
        return this.redstone ? 15 : 0;
    }

    @Override
    public int getLightEmission(BlockState state, BlockGetter level, BlockPos pos) {
        return this.redstone ? 7 : 15;
    }

    private void updateNeighbors(BlockState pState, Level pLevel, BlockPos pPos) {
        pLevel.updateNeighborsAt(pPos, (Block)this);
    }

    public void onRemove(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pIsMoving && !pState.is(pNewState.getBlock())) {
            this.updateNeighbors(pState, pLevel, pPos);
            super.onRemove(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public boolean canConnectRedstone(BlockState state, BlockGetter level, BlockPos pos, @Nullable Direction direction) {
        return this.redstone;
    }
}

