/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom.food;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.stats.Stats;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.BlockHitResult;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class BerryCakeBlock
extends SmallFurnitureBlock {
    public static final int MAX_BITES = 3;
    public static final IntegerProperty BITES = IntegerProperty.create((String)"bites", (int)0, (int)3);

    public BerryCakeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)BITES, (Comparable)Integer.valueOf(0)));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHit) {
        if (pLevel.isClientSide) {
            if (BerryCakeBlock.eat((LevelAccessor)pLevel, pPos, pState, pPlayer).consumesAction()) {
                return InteractionResult.SUCCESS;
            }
            if (pPlayer.getItemInHand(InteractionHand.MAIN_HAND).isEmpty()) {
                return InteractionResult.CONSUME;
            }
        }
        return BerryCakeBlock.eat((LevelAccessor)pLevel, pPos, pState, pPlayer);
    }

    protected static InteractionResult eat(LevelAccessor pLevel, BlockPos pPos, BlockState pState, Player pPlayer) {
        if (!pPlayer.canEat(false)) {
            return InteractionResult.PASS;
        }
        pPlayer.awardStat(Stats.EAT_CAKE_SLICE);
        pPlayer.getFoodData().eat(5, 0.3f);
        int bites = (Integer)pState.getValue((Property)BITES);
        pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.EAT, pPos);
        if (bites < 3) {
            pLevel.setBlock(pPos, (BlockState)pState.setValue((Property)BITES, (Comparable)Integer.valueOf(bites + 1)), 3);
        } else {
            pLevel.removeBlock(pPos, false);
            pLevel.gameEvent((Entity)pPlayer, (Holder)GameEvent.BLOCK_DESTROY, pPos);
        }
        return InteractionResult.SUCCESS;
    }

    @Override
    public BlockState updateShape(BlockState pState, Direction pFacing, BlockState pFacingState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pFacingPos) {
        return pFacing == Direction.DOWN && !pState.canSurvive((LevelReader)pLevel, pCurrentPos) ? Blocks.AIR.defaultBlockState() : super.updateShape(pState, pFacing, pFacingState, pLevel, pCurrentPos, pFacingPos);
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        return pLevel.getBlockState(pPos.below()).isSolid();
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{BITES});
    }
}

