/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class WillowVinesBlock
extends Block
implements BonemealableBlock {
    private static final VoxelShape SHAPE = Block.box((double)1.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0, (double)15.0);
    private static final int MAX_GRADIENT = 6;
    public static final IntegerProperty GRADIENT = IntegerProperty.create((String)"gradient", (int)1, (int)6);
    public static final BooleanProperty BOTTOM = BlockStateProperties.BOTTOM;

    public WillowVinesBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true))).setValue((Property)GRADIENT, (Comparable)Integer.valueOf(1)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return SHAPE;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean shouldEnd;
        BlockPos abovePos = pContext.getClickedPos().above();
        BlockPos belowPos = pContext.getClickedPos().below();
        BlockState aboveBlock = pContext.getLevel().getBlockState(abovePos);
        BlockState belowBlock = pContext.getLevel().getBlockState(belowPos);
        boolean bl = shouldEnd = !belowBlock.is(this.asBlock());
        int gradientColor = aboveBlock.equals(this.asBlock()) ? ((Integer)aboveBlock.getValue((Property)GRADIENT) < 6 ? (Integer)aboveBlock.getValue((Property)GRADIENT) + 1 : 6) : 1;
        return (BlockState)((BlockState)this.defaultBlockState().setValue((Property)GRADIENT, (Comparable)Integer.valueOf(gradientColor))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(shouldEnd));
    }

    public void tick(BlockState pState, ServerLevel pLevel, BlockPos pPos, RandomSource pRandom) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.destroyBlock(pPos, true);
        }
    }

    public BlockState updateShape(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pPos, BlockPos pNeighborPos) {
        if (!pState.canSurvive((LevelReader)pLevel, pPos)) {
            pLevel.scheduleTick(pPos, (Block)this, 1);
        }
        int gradient = 1;
        BlockPos abovePos = pPos.above();
        BlockState aboveState = pLevel.getBlockState(abovePos);
        BlockPos belowPos = pPos.below();
        BlockState belowState = pLevel.getBlockState(belowPos);
        if (aboveState.hasProperty((Property)GRADIENT) && (gradient = (Integer)aboveState.getValue((Property)GRADIENT) + 1) > 6) {
            gradient = 6;
        }
        boolean shouldEnd = !belowState.getBlock().equals(this.asBlock());
        return (BlockState)((BlockState)pState.setValue((Property)GRADIENT, (Comparable)Integer.valueOf(gradient))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(shouldEnd));
    }

    public boolean canSurvive(BlockState pState, LevelReader pLevel, BlockPos pPos) {
        BlockPos blockpos = pPos.above();
        BlockState blockstate = pLevel.getBlockState(blockpos);
        return blockstate.getBlock().equals(this.asBlock()) || blockstate.isFaceSturdy((BlockGetter)pLevel, blockpos, Direction.DOWN) || blockstate.getBlock() instanceof LeavesBlock || Block.canSupportCenter((LevelReader)pLevel, (BlockPos)blockpos, (Direction)Direction.DOWN);
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{GRADIENT}).add(new Property[]{BOTTOM});
    }

    public boolean isValidBonemealTarget(LevelReader level, BlockPos pos, BlockState state) {
        return true;
    }

    public boolean isBonemealSuccess(Level pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        return true;
    }

    public void performBonemeal(ServerLevel pLevel, RandomSource pRandom, BlockPos pPos, BlockState pState) {
        boolean vineBelow = true;
        while (vineBelow) {
            if (pLevel.getBlockState(pPos.below()).getBlock().equals(this.asBlock())) {
                pPos = pPos.below();
                continue;
            }
            vineBelow = false;
        }
        if (pLevel.getBlockState(pPos.below()).isAir()) {
            int gradient = Math.min((Integer)pState.getValue((Property)GRADIENT), 6);
            pLevel.setBlock(pPos.below(), (BlockState)((BlockState)pState.setValue((Property)GRADIENT, (Comparable)Integer.valueOf(gradient))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)), 2);
            if (pLevel.getBlockState(pPos.below(2)).isAir() && pRandom.nextFloat() < 0.2f) {
                pLevel.setBlock(pPos.below(2), (BlockState)((BlockState)pState.setValue((Property)GRADIENT, (Comparable)Integer.valueOf(gradient))).setValue((Property)BOTTOM, (Comparable)Boolean.valueOf(true)), 2);
            }
        }
    }
}

