/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.CustomHorizontalBlock;
import net.redchujelly.cluttered.block.custom.furniture.PicketFenceGateOpen;

public class PicketFenceGateBlock
extends CustomHorizontalBlock {
    private static final VoxelShape SHAPE_NS = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    private static final VoxelShape COLLISION_SHAPE_NS = Block.box((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)24.0, (double)10.0);
    private static final VoxelShape SUPPORT_SHAPE_NS = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0), SHAPE_NS});
    private static final VoxelShape SHAPE_EW = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);
    private static final VoxelShape COLLISION_SHAPE_EW = Block.box((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)24.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_EW = Shapes.or((VoxelShape)Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0), SHAPE_EW});
    public static final EnumProperty<PicketFenceGateOpen> OPEN_STATE = EnumProperty.create((String)"open_state", PicketFenceGateOpen.class);
    public static final BooleanProperty POWERED = BlockStateProperties.POWERED;

    public PicketFenceGateBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(OPEN_STATE, (Comparable)((Object)PicketFenceGateOpen.CLOSED))).setValue((Property)POWERED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SHAPE_NS : SHAPE_EW;
    }

    public VoxelShape getCollisionShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        PicketFenceGateOpen openState = (PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE));
        if (openState.equals((Object)PicketFenceGateOpen.CLOSED)) {
            Direction facing = (Direction)pState.getValue((Property)FACING);
            return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? COLLISION_SHAPE_NS : COLLISION_SHAPE_EW;
        }
        return Shapes.empty();
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        Level level = pContext.getLevel();
        BlockPos blockpos = pContext.getClickedPos();
        boolean powered = level.hasNeighborSignal(blockpos);
        PicketFenceGateOpen openState = PicketFenceGateOpen.CLOSED;
        if (powered) {
            openState = PicketFenceGateOpen.FORWARD;
        }
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)pContext.getHorizontalDirection().getOpposite())).setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue(OPEN_STATE, (Comparable)((Object)openState));
    }

    protected InteractionResult useWithoutItem(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, BlockHitResult pHitResult) {
        if (!pLevel.isClientSide) {
            if (!((PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE))).equals((Object)PicketFenceGateOpen.CLOSED)) {
                pLevel.setBlock(pPos, (BlockState)pState.setValue(OPEN_STATE, (Comparable)((Object)PicketFenceGateOpen.CLOSED)), 10);
                pLevel.playSound(null, pPos, SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS);
            } else {
                Direction blockFacing;
                Direction playerFacing = pPlayer.getDirection();
                if (!playerFacing.equals((Object)(blockFacing = (Direction)pState.getValue((Property)FACING)))) {
                    pLevel.setBlock(pPos, (BlockState)pState.setValue(OPEN_STATE, (Comparable)((Object)PicketFenceGateOpen.FORWARD)), 10);
                } else {
                    pLevel.setBlock(pPos, (BlockState)pState.setValue(OPEN_STATE, (Comparable)((Object)PicketFenceGateOpen.BACKWARD)), 10);
                }
                pLevel.playSound(null, pPos, SoundEvents.FENCE_GATE_OPEN, SoundSource.BLOCKS);
            }
        }
        return InteractionResult.sidedSuccess((boolean)pLevel.isClientSide);
    }

    public void neighborChanged(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.isClientSide) {
            PicketFenceGateOpen opensTo;
            boolean powered = pLevel.hasNeighborSignal(pPos);
            PicketFenceGateOpen picketFenceGateOpen = opensTo = powered ? PicketFenceGateOpen.FORWARD : PicketFenceGateOpen.CLOSED;
            if ((Boolean)pState.getValue((Property)POWERED) != powered) {
                pLevel.setBlock(pPos, (BlockState)((BlockState)pState.setValue((Property)POWERED, (Comparable)Boolean.valueOf(powered))).setValue(OPEN_STATE, (Comparable)((Object)opensTo)), 2);
                if (((PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE))).equals((Object)PicketFenceGateOpen.CLOSED) && powered) {
                    pLevel.playSound(null, pPos, SoundEvents.FENCE_GATE_OPEN, SoundSource.BLOCKS, 1.0f, pLevel.getRandom().nextFloat() * 0.1f + 0.9f);
                } else if (!((PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE))).equals((Object)PicketFenceGateOpen.CLOSED) && !powered) {
                    pLevel.playSound(null, pPos, SoundEvents.FENCE_GATE_CLOSE, SoundSource.BLOCKS, 1.0f, pLevel.getRandom().nextFloat() * 0.1f + 0.9f);
                }
            }
        }
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        return facing.equals((Object)Direction.NORTH) || facing.equals((Object)Direction.SOUTH) ? SUPPORT_SHAPE_NS : SUPPORT_SHAPE_EW;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OPEN_STATE}).add(new Property[]{POWERED});
    }

    public boolean isPathfindable(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        switch (pType) {
            case LAND: {
                return !((PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE))).equals((Object)PicketFenceGateOpen.CLOSED);
            }
            case WATER: {
                return false;
            }
            case AIR: {
                return !((PicketFenceGateOpen)((Object)pState.getValue(OPEN_STATE))).equals((Object)PicketFenceGateOpen.CLOSED);
            }
        }
        return false;
    }
}

