/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import java.util.HashMap;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RotatedPillarBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.common.ItemAbility;
import net.redchujelly.cluttered.setup.BlockRegistration;
import org.jetbrains.annotations.Nullable;

public class CustomLogLikeBlock
extends RotatedPillarBlock {
    public CustomLogLikeBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
    }

    private Block getStrippedCounterpart(Block block) {
        HashMap<Block, Block> strippedCounterparts = new HashMap<Block, Block>(){
            {
                this.put((Block)BlockRegistration.WILLOW_LOG.get(), (Block)BlockRegistration.STRIPPED_WILLOW_LOG.get());
                this.put((Block)BlockRegistration.WILLOW_WOOD.get(), (Block)BlockRegistration.STRIPPED_WILLOW_WOOD.get());
                this.put((Block)BlockRegistration.FLOWERING_WILLOW_LOG.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_WILLOW_LOG.get());
                this.put((Block)BlockRegistration.FLOWERING_WILLOW_WOOD.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_WILLOW_WOOD.get());
                this.put((Block)BlockRegistration.POPLAR_LOG.get(), (Block)BlockRegistration.STRIPPED_POPLAR_LOG.get());
                this.put((Block)BlockRegistration.POPLAR_WOOD.get(), (Block)BlockRegistration.STRIPPED_POPLAR_WOOD.get());
                this.put((Block)BlockRegistration.FLOWERING_POPLAR_LOG.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_POPLAR_LOG.get());
                this.put((Block)BlockRegistration.FLOWERING_POPLAR_WOOD.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_POPLAR_WOOD.get());
                this.put((Block)BlockRegistration.CRABAPPLE_LOG.get(), (Block)BlockRegistration.STRIPPED_CRABAPPLE_LOG.get());
                this.put((Block)BlockRegistration.CRABAPPLE_WOOD.get(), (Block)BlockRegistration.STRIPPED_CRABAPPLE_WOOD.get());
                this.put((Block)BlockRegistration.FLOWERING_CRABAPPLE_LOG.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_CRABAPPLE_LOG.get());
                this.put((Block)BlockRegistration.FLOWERING_CRABAPPLE_WOOD.get(), (Block)BlockRegistration.STRIPPED_FLOWERING_CRABAPPLE_WOOD.get());
                this.put((Block)BlockRegistration.SYCAMORE_LOG.get(), (Block)BlockRegistration.STRIPPED_SYCAMORE_LOG.get());
                this.put((Block)BlockRegistration.SYCAMORE_WOOD.get(), (Block)BlockRegistration.STRIPPED_SYCAMORE_WOOD.get());
                this.put((Block)BlockRegistration.MAPLE_LOG.get(), (Block)BlockRegistration.STRIPPED_MAPLE_LOG.get());
                this.put((Block)BlockRegistration.MAPLE_WOOD.get(), (Block)BlockRegistration.STRIPPED_MAPLE_WOOD.get());
            }
        };
        return strippedCounterparts.getOrDefault(block, null);
    }

    public boolean isFlammable(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return true;
    }

    public int getFlammability(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    public int getFireSpreadSpeed(BlockState state, BlockGetter level, BlockPos pos, Direction direction) {
        return 5;
    }

    @Nullable
    public BlockState getToolModifiedState(BlockState state, UseOnContext context, ItemAbility itemAbility, boolean simulate) {
        if (context.getItemInHand().getItem() instanceof AxeItem && this.getStrippedCounterpart(state.getBlock()) != null) {
            return (BlockState)this.getStrippedCounterpart(state.getBlock()).defaultBlockState().setValue((Property)AXIS, (Comparable)((Direction.Axis)state.getValue((Property)AXIS)));
        }
        return super.getToolModifiedState(state, context, itemAbility, simulate);
    }
}

