/*
 * Decompiled with CFR 0.152.
 */
package net.redchujelly.cluttered.block.custom;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.redchujelly.cluttered.block.custom.furniture.SmallFurnitureBlock;

public class BracketBlock
extends SmallFurnitureBlock {
    private static final VoxelShape SHAPE_NORTH_UP = Shapes.join((VoxelShape)Block.box((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_NORTH_DOWN = Shapes.join((VoxelShape)Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)10.0, (double)9.0, (double)16.0, (double)16.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_UP = Shapes.join((VoxelShape)Block.box((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_EAST_DOWN = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)6.0, (double)9.0), (VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.0, (double)6.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_UP = Shapes.join((VoxelShape)Block.box((double)7.0, (double)10.0, (double)0.0, (double)9.0, (double)16.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_SOUTH_DOWN = Shapes.join((VoxelShape)Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)6.0, (double)16.0), (VoxelShape)Block.box((double)7.0, (double)0.0, (double)0.0, (double)9.0, (double)16.0, (double)6.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_UP = Shapes.join((VoxelShape)Block.box((double)0.0, (double)10.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SHAPE_WEST_DOWN = Shapes.join((VoxelShape)Block.box((double)0.0, (double)0.0, (double)7.0, (double)16.0, (double)6.0, (double)9.0), (VoxelShape)Block.box((double)10.0, (double)0.0, (double)7.0, (double)16.0, (double)16.0, (double)9.0), (BooleanOp)BooleanOp.OR);
    private static final VoxelShape SUPPORT_SHAPE_UP = Block.box((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_DOWN = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_SOUTH = Block.box((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape SUPPORT_SHAPE_NORTH = Block.box((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_WEST = Block.box((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SUPPORT_SHAPE_EAST = Block.box((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    public static final BooleanProperty OFFSET = BooleanProperty.create((String)"offset");
    public static final BooleanProperty IS_UP = BooleanProperty.create((String)"is_up");

    public BracketBlock(BlockBehaviour.Properties pProperties) {
        super(pProperties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue((Property)OFFSET, (Comparable)Boolean.valueOf(true)));
    }

    @Override
    public BlockState getStateForPlacement(BlockPlaceContext pContext) {
        boolean shouldBeUP;
        Direction clickedFace = pContext.getClickedFace();
        boolean bl = shouldBeUP = pContext.getClickLocation().y - (double)pContext.getClickedPos().getY() > 0.5;
        if (clickedFace.equals((Object)Direction.DOWN) || clickedFace.equals((Object)Direction.UP)) {
            shouldBeUP = clickedFace.equals((Object)Direction.DOWN);
            clickedFace = pContext.getHorizontalDirection().getOpposite();
        }
        BlockState behindState = pContext.getLevel().getBlockState(pContext.getClickedPos().relative(clickedFace.getOpposite()));
        return (BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue((Property)FACING, (Comparable)clickedFace)).setValue((Property)OFFSET, (Comparable)Boolean.valueOf(behindState.is(BlockTags.FENCES) || behindState.is(BlockTags.WOODEN_FENCES)))).setValue((Property)IS_UP, (Comparable)Boolean.valueOf(shouldBeUP));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        tooltipComponents.add((Component)Component.translatable((String)"cluttered.bracket.tooltip"));
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
    }

    public VoxelShape getBlockSupportShape(BlockState pState, BlockGetter pLevel, BlockPos pPos) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        boolean is_up = (Boolean)pState.getValue((Property)IS_UP);
        if (((Boolean)pState.getValue((Property)OFFSET)).booleanValue()) {
            return switch (facing) {
                case Direction.SOUTH -> {
                    if (is_up) {
                        yield SHAPE_SOUTH_UP;
                    }
                    yield SHAPE_SOUTH_DOWN;
                }
                case Direction.EAST -> {
                    if (is_up) {
                        yield SHAPE_EAST_UP;
                    }
                    yield SHAPE_EAST_DOWN;
                }
                case Direction.WEST -> {
                    if (is_up) {
                        yield SHAPE_WEST_UP;
                    }
                    yield SHAPE_WEST_DOWN;
                }
                default -> is_up ? SHAPE_NORTH_UP : SHAPE_NORTH_DOWN;
            };
        }
        VoxelShape shapeH = switch (facing) {
            case Direction.SOUTH -> SUPPORT_SHAPE_SOUTH;
            case Direction.EAST -> SUPPORT_SHAPE_EAST;
            case Direction.WEST -> SUPPORT_SHAPE_WEST;
            default -> SUPPORT_SHAPE_NORTH;
        };
        VoxelShape shapeV = is_up ? SUPPORT_SHAPE_UP : SUPPORT_SHAPE_DOWN;
        return Shapes.or((VoxelShape)shapeH, (VoxelShape)shapeV);
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.createBlockStateDefinition(pBuilder);
        pBuilder.add(new Property[]{OFFSET}).add(new Property[]{IS_UP});
    }

    @Override
    public VoxelShape getShape(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction facing = (Direction)pState.getValue((Property)FACING);
        boolean is_up = (Boolean)pState.getValue((Property)IS_UP);
        return switch (facing) {
            case Direction.SOUTH -> {
                if (is_up) {
                    yield SHAPE_SOUTH_UP;
                }
                yield SHAPE_SOUTH_DOWN;
            }
            case Direction.EAST -> {
                if (is_up) {
                    yield SHAPE_EAST_UP;
                }
                yield SHAPE_EAST_DOWN;
            }
            case Direction.WEST -> {
                if (is_up) {
                    yield SHAPE_WEST_UP;
                }
                yield SHAPE_WEST_DOWN;
            }
            default -> is_up ? SHAPE_NORTH_UP : SHAPE_NORTH_DOWN;
        };
    }
}

