/*
 * Decompiled with CFR 0.152.
 */
package mrtjp.projectred.transmission.part;

import codechicken.lib.vec.Rotation;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nullable;
import mrtjp.projectred.api.IBundledEmitter;
import mrtjp.projectred.api.IBundledTile;
import mrtjp.projectred.api.IConnectable;
import mrtjp.projectred.api.IMaskedBundledTile;
import mrtjp.projectred.core.BundledSignalsLib;
import mrtjp.projectred.core.FaceLookup;
import mrtjp.projectred.core.RedstonePropagator;
import mrtjp.projectred.core.part.IConnectableFacePart;
import mrtjp.projectred.core.part.IPropagationFacePart;
import mrtjp.projectred.core.part.IPropagationPart;
import mrtjp.projectred.transmission.WireType;
import mrtjp.projectred.transmission.part.BaseFaceWirePart;
import mrtjp.projectred.transmission.part.IBundledCablePart;
import mrtjp.projectred.transmission.part.IBundledPropagationPart;
import mrtjp.projectred.transmission.part.IInsulatedRedwirePart;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;

public class BundledCablePart
extends BaseFaceWirePart
implements IBundledCablePart,
IBundledPropagationPart,
IPropagationFacePart {
    private final byte[] signal = new byte[16];
    private final byte[] tmpSignal = new byte[16];
    private int colourPropagationMask = 65535;

    public BundledCablePart(WireType wireType) {
        super(wireType);
    }

    @Override
    public byte[] getSignal() {
        return this.signal;
    }

    @Override
    public void setSignal(@Nullable byte[] signal) {
        if (signal == null) {
            Arrays.fill(this.signal, (byte)0);
        } else {
            System.arraycopy(signal, 0, this.signal, 0, 16);
        }
    }

    @Override
    public int getColorMask() {
        return this.colourPropagationMask;
    }

    @Override
    public void setColorMask(int mask) {
        this.colourPropagationMask = mask;
    }

    @Override
    public void save(CompoundTag tag, HolderLookup.Provider registries) {
        super.save(tag, registries);
        tag.putByteArray("signal", this.signal);
    }

    @Override
    public void load(CompoundTag tag, HolderLookup.Provider registries) {
        super.load(tag, registries);
        this.setSignal(tag.getByteArray("signal"));
    }

    @Override
    public void maskChangeEvent(boolean internalChange, boolean externalChange) {
        super.maskChangeEvent(internalChange, externalChange);
        RedstonePropagator.logCalculation();
        RedstonePropagator.propagateTo((IPropagationPart)this, (int)(internalChange || externalChange ? 2 : 0));
    }

    public boolean canConnectPart(IConnectable part, int dir) {
        if (part instanceof IBundledCablePart) {
            int b1 = ((IBundledCablePart)part).getBundledColour();
            int b2 = this.getBundledColour();
            return b1 == -1 || b2 == -1 || b1 == b2;
        }
        if (part instanceof IInsulatedRedwirePart) {
            return true;
        }
        return part instanceof IBundledEmitter;
    }

    public boolean discoverStraightOverride(int absDir) {
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)Rotation.rotationTo((int)this.getSide(), (int)absDir));
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof IMaskedBundledTile) {
            IMaskedBundledTile b = (IMaskedBundledTile)blockEntity;
            int r = Rotation.rotationTo((int)absDir, (int)this.getSide());
            return b.canConnectBundled(absDir ^ 1) && (b.getConnectionMask(absDir ^ 1) & 1 << r) != 0;
        }
        blockEntity = lookup.tile;
        if (blockEntity instanceof IBundledTile) {
            IBundledTile b = (IBundledTile)blockEntity;
            return b.canConnectBundled(absDir ^ 1);
        }
        return BundledSignalsLib.canConnectBundledViaInteraction((Level)this.level(), (BlockPos)lookup.otherPos, (Direction)Direction.values()[absDir ^ 1]);
    }

    public boolean discoverCornerOverride(int absDir) {
        int r = IConnectableFacePart.absoluteRot((IConnectableFacePart)this, (int)absDir);
        FaceLookup lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        BlockEntity blockEntity = lookup.tile;
        if (blockEntity instanceof IMaskedBundledTile) {
            IMaskedBundledTile b = (IMaskedBundledTile)blockEntity;
            int edgeRot = Rotation.rotationTo((int)this.getSide(), (int)(absDir ^ 1));
            return b.canConnectBundled(lookup.otherDir) && (b.getConnectionMask(lookup.otherDir) & 1 << edgeRot) != 0;
        }
        blockEntity = lookup.tile;
        if (blockEntity instanceof IBundledTile) {
            IBundledTile b = (IBundledTile)blockEntity;
            return b.canConnectBundled(lookup.otherDir);
        }
        return false;
    }

    @Nullable
    public byte[] getBundledSignal(int dir) {
        return this.maskConnects(dir) ? this.signal : null;
    }

    public void onSignalUpdate() {
    }

    @Override
    public byte[] getBundledSignal() {
        return this.signal;
    }

    @Override
    public int getBundledColour() {
        return this.getWireType().getColourIdx();
    }

    @Override
    public byte[] calculateSignal() {
        Arrays.fill(this.tmpSignal, (byte)0);
        for (int r = 0; r < 4; ++r) {
            if (this.maskConnectsCorner(r)) {
                this.calcCornerSignal(r);
                continue;
            }
            if (this.maskConnectsStraight(r)) {
                this.calcStraightSignal(r);
                continue;
            }
            if (!this.maskConnectsInside(r)) continue;
            this.calcInsideSignal(r);
        }
        if (this.maskConnectsCenter()) {
            this.calcCenterSignal();
        }
        return this.tmpSignal;
    }

    protected void calcCornerSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupCorner((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        this.resolveSignal(lookup);
    }

    protected void calcStraightSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupStraight((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        this.resolveSignal(lookup);
    }

    protected void calcInsideSignal(int r) {
        FaceLookup lookup = FaceLookup.lookupInsideFace((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide(), (int)r);
        this.resolveSignal(lookup);
    }

    protected void calcCenterSignal() {
        FaceLookup lookup = FaceLookup.lookupInsideCenter((Level)this.level(), (BlockPos)this.pos(), (int)this.getSide());
        this.resolveSignal(lookup);
    }

    protected void resolveSignal(FaceLookup lookup) {
        if (lookup.part instanceof IBundledCablePart) {
            byte[] signalIn = ((IBundledCablePart)lookup.part).getBundledSignal();
            for (int i = 0; i < 16; ++i) {
                this.tmpSignal[i] = (byte)Math.max(this.tmpSignal[i] & 0xFF, (signalIn[i] & 0xFF) - 1);
            }
        } else {
            Object signalIn = lookup.part;
            if (signalIn instanceof IInsulatedRedwirePart) {
                IInsulatedRedwirePart insulatedWire = (IInsulatedRedwirePart)signalIn;
                int c = insulatedWire.getInsulatedColour();
                int signalIn2 = insulatedWire.getRedwireSignal(lookup.otherRotation);
                this.tmpSignal[c] = (byte)Math.max(this.tmpSignal[c] & 0xFF, signalIn2 - 1);
            } else if (lookup.part instanceof IBundledEmitter) {
                signalIn = ((IBundledEmitter)lookup.part).getBundledSignal(lookup.otherRotation);
                BundledSignalsLib.raiseSignal((byte[])this.tmpSignal, (byte[])signalIn);
            } else if (lookup.tile instanceof IBundledTile) {
                signalIn = ((IBundledTile)lookup.tile).getBundledSignal(Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation));
                BundledSignalsLib.raiseSignal((byte[])this.tmpSignal, (byte[])signalIn);
            } else if (lookup.tile != null) {
                byte[] externalSignal = BundledSignalsLib.getBundledSignalViaInteraction((Level)Objects.requireNonNull(lookup.tile.getLevel()), (BlockPos)lookup.tile.getBlockPos(), (Direction)Direction.values()[Rotation.rotateSide((int)lookup.otherSide, (int)lookup.otherRotation)]);
                BundledSignalsLib.raiseSignal((byte[])this.tmpSignal, (byte[])externalSignal);
            }
        }
    }

    @Override
    public boolean useStaticRenderer() {
        return true;
    }
}

