/*
 * Decompiled with CFR 0.152.
 */
package com.mcwroofs.kikoz.objects.gutters;

import com.mcwroofs.kikoz.init.BlockInit;
import com.mcwroofs.kikoz.init.ItemInit;
import com.mcwroofs.kikoz.objects.roofs.AwningBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.DyeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.block.state.properties.StairsShape;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RainGutter
extends AwningBlock {
    private static final BooleanProperty WATER = BooleanProperty.create((String)"water");
    private static final VoxelShape[] SHAPES = new VoxelShape[12];

    private int getShapeIndex(StairsShape shape, Direction facing) {
        switch (shape) {
            case OUTER_RIGHT: {
                return switch (facing) {
                    case Direction.WEST -> 10;
                    case Direction.EAST -> 8;
                    case Direction.SOUTH -> 9;
                    case Direction.NORTH -> 11;
                    default -> -1;
                };
            }
            case INNER_RIGHT: {
                return switch (facing) {
                    case Direction.WEST -> 6;
                    case Direction.EAST -> 4;
                    case Direction.SOUTH -> 5;
                    case Direction.NORTH -> 7;
                    default -> -1;
                };
            }
            case OUTER_LEFT: {
                return switch (facing) {
                    case Direction.WEST -> 9;
                    case Direction.EAST -> 11;
                    case Direction.SOUTH -> 8;
                    case Direction.NORTH -> 10;
                    default -> -1;
                };
            }
            case INNER_LEFT: {
                return switch (facing) {
                    case Direction.WEST -> 5;
                    case Direction.EAST -> 7;
                    case Direction.SOUTH -> 4;
                    case Direction.NORTH -> 6;
                    default -> -1;
                };
            }
        }
        return switch (facing) {
            case Direction.WEST -> 2;
            case Direction.EAST -> 0;
            case Direction.SOUTH -> 1;
            case Direction.NORTH -> 3;
            default -> -1;
        };
    }

    @Override
    public VoxelShape getShape(BlockState state, BlockGetter blockReader, BlockPos pos, CollisionContext selectionContext) {
        Direction facing;
        StairsShape shape = (StairsShape)state.getValue((Property)SHAPE);
        int shapeIndex = this.getShapeIndex(shape, facing = (Direction)state.getValue((Property)FACING));
        return shapeIndex >= 0 && shapeIndex < SHAPES.length ? SHAPES[shapeIndex] : Shapes.empty();
    }

    public RainGutter(BlockState state, BlockBehaviour.Properties prop) {
        super(state, prop);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.stateDefinition.any()).setValue((Property)WATER, (Comparable)Boolean.valueOf(false))).setValue((Property)FACING, (Comparable)Direction.NORTH)).setValue((Property)SHAPE, (Comparable)StairsShape.STRAIGHT));
    }

    @Override
    public ItemInteractionResult useItemOn(ItemStack itemstack, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        Item item = itemstack.getItem();
        Boolean i = (Boolean)state.getValue((Property)WATER);
        ItemStack heldItem = player.getItemInHand(hand);
        if (item == ItemInit.ROOFING_HAMMER.get()) {
            state = (BlockState)state.cycle((Property)SHAPE);
            world.setBlock(pos, state, 2);
        }
        if (item == Items.WATER_BUCKET && !i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.BUCKET));
        }
        if (item == Items.BUCKET && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            itemstack.shrink(1);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.WATER_BUCKET));
        }
        if (item == Items.GLASS_BOTTLE && i.booleanValue()) {
            state = (BlockState)state.cycle((Property)WATER);
            world.setBlock(pos, state, 2);
            player.setItemInHand(hand, new ItemStack((ItemLike)Items.POTION));
        }
        if (item instanceof DyeItem) {
            DyeColor dyeColor = ((DyeItem)item).getDyeColor();
            Block blockToPlace = null;
            switch (dyeColor) {
                case WHITE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_WHITE.get();
                    break;
                }
                case LIGHT_GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIGHT_GRAY.get();
                    break;
                }
                case GRAY: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_GRAY.get();
                    break;
                }
                case BLACK: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BLACK.get();
                    break;
                }
                case BROWN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BROWN.get();
                    break;
                }
                case RED: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_RED.get();
                    break;
                }
                case ORANGE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_ORANGE.get();
                    break;
                }
                case YELLOW: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_YELLOW.get();
                    break;
                }
                case LIME: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIME.get();
                    break;
                }
                case GREEN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_GREEN.get();
                    break;
                }
                case CYAN: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_CYAN.get();
                    break;
                }
                case LIGHT_BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_LIGHT_BLUE.get();
                    break;
                }
                case BLUE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_BLUE.get();
                    break;
                }
                case PURPLE: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_PURPLE.get();
                    break;
                }
                case MAGENTA: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_MAGENTA.get();
                    break;
                }
                case PINK: {
                    blockToPlace = (Block)BlockInit.GUTTER_BASE_PINK.get();
                    break;
                }
                default: {
                    return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
                }
            }
            Direction currentFacing = (Direction)state.getValue((Property)FACING);
            Boolean currentWater = (Boolean)state.getValue((Property)WATER);
            StairsShape currentAbove = (StairsShape)state.getValue((Property)SHAPE);
            BlockState newState = (BlockState)((BlockState)((BlockState)blockToPlace.defaultBlockState().setValue((Property)FACING, (Comparable)currentFacing)).setValue((Property)WATER, (Comparable)currentWater)).setValue((Property)SHAPE, (Comparable)currentAbove);
            world.setBlockAndUpdate(pos, newState);
            if (!player.getAbilities().instabuild) {
                heldItem.shrink(1);
            }
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static boolean isBlockStairs(BlockState state) {
        return state.getBlock() instanceof RainGutter;
    }

    public boolean isRandomlyTicking(BlockState state) {
        return true;
    }

    public void randomTick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (state.hasProperty((Property)WATER)) {
            if (world.isRainingAt(blockpos) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
            if (!world.isRainingAt(blockpos) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
                this.scheduleClear(world, pos);
            }
        }
    }

    public void tick(BlockState state, ServerLevel world, BlockPos pos, RandomSource random) {
        BlockPos blockpos = pos.above(30);
        if (world.isRainingAt(blockpos)) {
            if (state.hasProperty((Property)WATER) && !((Boolean)state.getValue((Property)WATER)).booleanValue()) {
                world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(true)));
                this.scheduleSpread(world, pos);
            }
        } else if (state.hasProperty((Property)WATER) && ((Boolean)state.getValue((Property)WATER)).booleanValue()) {
            world.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)WATER, (Comparable)Boolean.valueOf(false)));
            this.scheduleClear(world, pos);
        }
    }

    private void scheduleSpread(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.getBlockState(neighbor);
            if (neighborState.getBlock() != state.getBlock() || !neighborState.hasProperty((Property)WATER) || ((Boolean)neighborState.getValue((Property)WATER)).booleanValue()) continue;
            world.scheduleTick(neighbor, (Block)this, 6);
        }
    }

    private void scheduleClear(ServerLevel world, BlockPos pos) {
        BlockState state = world.getBlockState(pos);
        for (BlockPos neighbor : this.getNeighborPositions(pos)) {
            BlockState neighborState = world.getBlockState(neighbor);
            if (neighborState.getBlock() != state.getBlock() || !neighborState.hasProperty((Property)WATER) || !((Boolean)neighborState.getValue((Property)WATER)).booleanValue()) continue;
            world.scheduleTick(neighbor, (Block)this, 6);
        }
    }

    private List<BlockPos> getNeighborPositions(BlockPos pos) {
        return List.of(pos.north(), pos.south(), pos.east(), pos.west());
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{WATER, FACING, SHAPE});
    }

    static {
        RainGutter.SHAPES[0] = Shapes.or((VoxelShape)Block.box((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)16.0), Block.box((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[1] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.box((double)0.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[2] = Shapes.or((VoxelShape)Block.box((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[3] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[4] = Shapes.or((VoxelShape)Block.box((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)12.0), Block.box((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)15.0), Block.box((double)0.0, (double)12.0, (double)11.0, (double)11.0, (double)15.0, (double)12.0), Block.box((double)0.0, (double)12.0, (double)15.0, (double)15.0, (double)15.0, (double)16.0), Block.box((double)0.0, (double)11.0, (double)12.0, (double)12.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[5] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.box((double)1.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0), Block.box((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)11.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)15.0), Block.box((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)12.0)});
        RainGutter.SHAPES[6] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)4.0, (double)12.0, (double)4.0, (double)5.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)1.0, (double)4.0, (double)12.0, (double)16.0), Block.box((double)5.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), Block.box((double)1.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)4.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[7] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0, (double)5.0), Block.box((double)0.0, (double)11.0, (double)1.0, (double)15.0, (double)12.0, (double)4.0), Block.box((double)11.0, (double)12.0, (double)5.0, (double)12.0, (double)15.0, (double)16.0), Block.box((double)15.0, (double)12.0, (double)1.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)12.0, (double)11.0, (double)4.0, (double)15.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[8] = Shapes.or((VoxelShape)Block.box((double)11.0, (double)12.0, (double)11.0, (double)12.0, (double)15.0, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)11.0, (double)12.0, (double)15.0, (double)12.0, (double)16.0), Block.box((double)15.0, (double)12.0, (double)15.0, (double)16.0, (double)15.0, (double)16.0), Block.box((double)12.0, (double)12.0, (double)11.0, (double)16.0, (double)15.0, (double)12.0), Block.box((double)15.0, (double)11.0, (double)12.0, (double)16.0, (double)12.0, (double)15.0)});
        RainGutter.SHAPES[9] = Shapes.or((VoxelShape)Block.box((double)0.0, (double)12.0, (double)11.0, (double)5.0, (double)15.0, (double)12.0), (VoxelShape[])new VoxelShape[]{Block.box((double)0.0, (double)11.0, (double)12.0, (double)4.0, (double)12.0, (double)15.0), Block.box((double)0.0, (double)12.0, (double)15.0, (double)1.0, (double)15.0, (double)16.0), Block.box((double)4.0, (double)12.0, (double)12.0, (double)5.0, (double)15.0, (double)16.0), Block.box((double)1.0, (double)11.0, (double)15.0, (double)4.0, (double)12.0, (double)16.0)});
        RainGutter.SHAPES[10] = Shapes.or((VoxelShape)Block.box((double)4.0, (double)12.0, (double)0.0, (double)5.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)1.0, (double)11.0, (double)0.0, (double)4.0, (double)12.0, (double)4.0), Block.box((double)0.0, (double)12.0, (double)0.0, (double)1.0, (double)15.0, (double)1.0), Block.box((double)0.0, (double)12.0, (double)4.0, (double)4.0, (double)15.0, (double)5.0), Block.box((double)0.0, (double)11.0, (double)1.0, (double)1.0, (double)12.0, (double)4.0)});
        RainGutter.SHAPES[11] = Shapes.or((VoxelShape)Block.box((double)11.0, (double)12.0, (double)4.0, (double)16.0, (double)15.0, (double)5.0), (VoxelShape[])new VoxelShape[]{Block.box((double)12.0, (double)11.0, (double)1.0, (double)16.0, (double)12.0, (double)4.0), Block.box((double)15.0, (double)12.0, (double)0.0, (double)16.0, (double)15.0, (double)1.0), Block.box((double)11.0, (double)12.0, (double)0.0, (double)12.0, (double)15.0, (double)4.0), Block.box((double)12.0, (double)11.0, (double)0.0, (double)15.0, (double)12.0, (double)1.0)});
    }
}

