/*
 * Decompiled with CFR 0.152.
 */
package plus.dragons.createdragonsplus.data.recipe;

import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.advancements.Advancement;
import net.minecraft.advancements.AdvancementHolder;
import net.minecraft.advancements.AdvancementRequirements;
import net.minecraft.advancements.AdvancementRewards;
import net.minecraft.advancements.Criterion;
import net.minecraft.advancements.critereon.RecipeUnlockedTrigger;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.AbstractCookingRecipe;
import net.minecraft.world.item.crafting.CookingBookCategory;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeHolder;
import org.jetbrains.annotations.Nullable;
import plus.dragons.createdragonsplus.data.recipe.BaseSingleItemRecipeBuilder;

public class CookingRecipeBuilder<R extends AbstractCookingRecipe>
extends BaseSingleItemRecipeBuilder<R, CookingRecipeBuilder<R>> {
    private final AbstractCookingRecipe.Factory<R> factory;
    private float experience;
    private int cookingTime;
    private final Map<String, Criterion<?>> criteria = new LinkedHashMap();
    private CookingBookCategory category = CookingBookCategory.MISC;
    private String group = "";

    protected CookingRecipeBuilder(@Nullable String directory, AbstractCookingRecipe.Factory<R> factory) {
        super(directory);
        this.factory = factory;
    }

    public CookingRecipeBuilder(@Nullable String directory, AbstractCookingRecipe.Factory<R> factory, int cookingTime) {
        super(directory);
        this.factory = factory;
        this.cookingTime = cookingTime;
    }

    public CookingRecipeBuilder<R> experience(float experience) {
        this.experience = experience;
        return this;
    }

    public CookingRecipeBuilder<R> cookingTime(int cookingTime) {
        this.cookingTime = cookingTime;
        return this;
    }

    public CookingRecipeBuilder<R> unlockedBy(String name, Criterion<?> criterion) {
        this.criteria.put(name, criterion);
        return this;
    }

    public CookingRecipeBuilder<R> category(CookingBookCategory category) {
        this.category = category;
        return this;
    }

    public CookingRecipeBuilder<R> group(String group) {
        this.group = group;
        return this;
    }

    @Override
    protected CookingRecipeBuilder<R> builder() {
        return this;
    }

    @Override
    public RecipeHolder<R> build() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        AbstractCookingRecipe recipe = this.factory.create(this.group, this.category, this.ingredient, this.result, this.experience, this.cookingTime);
        return new RecipeHolder(this.id, (Recipe)recipe);
    }

    @Override
    @Nullable
    public AdvancementHolder buildAdvancement() {
        if (this.id == null) {
            this.id = ((ResourceKey)this.result.getItemHolder().unwrapKey().orElseThrow()).location();
        }
        Advancement.Builder builder = Advancement.Builder.advancement().addCriterion("has_the_recipe", RecipeUnlockedTrigger.unlocked((ResourceLocation)this.id)).rewards(AdvancementRewards.Builder.recipe((ResourceLocation)this.id)).requirements(AdvancementRequirements.Strategy.OR);
        this.criteria.forEach((arg_0, arg_1) -> ((Advancement.Builder)builder).addCriterion(arg_0, arg_1));
        return builder.build(this.id);
    }
}

