/*
 * Decompiled with CFR 0.152.
 */
package com.jesz.createdieselgenerators.content.tools;

import com.jesz.createdieselgenerators.CDGConfig;
import com.jesz.createdieselgenerators.CDGDataComponents;
import com.simibubi.create.AllEnchantments;
import com.simibubi.create.foundation.utility.CreateLang;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.ItemEnchantments;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.SimpleFluidContent;
import net.neoforged.neoforge.fluids.capability.templates.FluidHandlerItemStack;

public interface FueledToolItem {
    default public int getBaseCapacity(ItemStack stack) {
        return (Integer)CDGConfig.TOOL_CAPACITY.get();
    }

    default public int getCapacityEnchantmentAddition(ItemStack stack) {
        return (Integer)CDGConfig.TOOL_CAPACITY_ENCHANTMENT.get();
    }

    default public int getCapacity(ItemStack stack) {
        int enchantmentLevel = 0;
        if (stack.has(DataComponents.ENCHANTMENTS)) {
            for (Object2IntMap.Entry enchantment : ((ItemEnchantments)stack.get(DataComponents.ENCHANTMENTS)).entrySet()) {
                if (!((Holder)enchantment.getKey()).is(AllEnchantments.CAPACITY)) continue;
                enchantmentLevel = enchantment.getIntValue();
            }
        }
        return this.getBaseCapacity(stack) + this.getCapacityEnchantmentAddition(stack) * enchantmentLevel;
    }

    default public FluidStack readFluid(ItemStack stack) {
        return stack.has(CDGDataComponents.FLUID_CONTENTS) ? ((SimpleFluidContent)stack.get(CDGDataComponents.FLUID_CONTENTS)).copy() : FluidStack.EMPTY;
    }

    default public void writeFluid(ItemStack stack, FluidStack fluid) {
        stack.set(CDGDataComponents.FLUID_CONTENTS, (Object)SimpleFluidContent.copyOf((FluidStack)fluid));
    }

    default public int getCurrentFillLevel(ItemStack stack) {
        return this.readFluid(stack).getAmount();
    }

    default public void createTooltip(List<Component> tooltip, ItemStack stack) {
        if (stack.has(CDGDataComponents.FLUID_CONTENTS)) {
            FluidStack fluid = this.readFluid(stack);
            if (fluid.isEmpty()) {
                tooltip.add((Component)Component.translatable((String)"createdieselgenerators.tooltip.empty").withStyle(ChatFormatting.GRAY));
                return;
            }
            tooltip.add((Component)CreateLang.fluidName((FluidStack)fluid).component().withStyle(ChatFormatting.GRAY).append(" ").append((Component)CreateLang.number((double)fluid.getAmount()).style(ChatFormatting.GOLD).component()).append((Component)Component.translatable((String)"create.generic.unit.millibuckets").withStyle(ChatFormatting.GOLD)).append((Component)Component.literal((String)" / ")).append((Component)CreateLang.number((double)this.getCapacity(stack)).style(ChatFormatting.GRAY).component()).append((Component)Component.translatable((String)"create.generic.unit.millibuckets").withStyle(ChatFormatting.GRAY)));
            return;
        }
        tooltip.add((Component)Component.translatable((String)"createdieselgenerators.tooltip.empty").withStyle(ChatFormatting.GRAY));
    }

    default public FluidHandlerItemStack getFluidHandler(ItemStack stack) {
        return new FluidHandlerItemStack(() -> CDGDataComponents.FLUID_CONTENTS, stack, this.getCapacity(stack));
    }
}

