/*
 * Decompiled with CFR 0.152.
 */
package com.copycatsplus.copycats.utility;

import com.copycatsplus.copycats.utility.neoforge.InteractionUtilsImpl;
import dev.architectury.injectables.annotations.ExpectPlatform;
import java.util.function.Supplier;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class InteractionUtils {
    @SafeVarargs
    public static InteractionResult sequential(Supplier<InteractionResult> ... handlers) {
        for (Supplier<InteractionResult> handler : handlers) {
            InteractionResult result = handler.get();
            if (!result.consumesAction()) continue;
            return result;
        }
        return InteractionResult.PASS;
    }

    @SafeVarargs
    public static ItemInteractionResult sequentialItem(Supplier<ItemInteractionResult> ... handlers) {
        for (Supplier<ItemInteractionResult> handler : handlers) {
            ItemInteractionResult result = handler.get();
            if (!result.consumesAction()) continue;
            return result;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    public static ItemInteractionResult usePlacementHelper(int placementHelperId, ItemStack heldItem, BlockState state, Level world, BlockPos pos, Player player, InteractionHand hand, BlockHitResult ray) {
        IPlacementHelper placementHelper;
        if (!player.isShiftKeyDown() && player.mayBuild() && (placementHelper = PlacementHelpers.get((int)placementHelperId)).matchesItem(heldItem)) {
            placementHelper.getOffset(player, world, state, pos, ray).placeInWorld(world, (BlockItem)heldItem.getItem(), player, hand, ray);
            return ItemInteractionResult.SUCCESS;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static AttributeInstance getPlayerReach(Player player) {
        return InteractionUtilsImpl.getPlayerReach(player);
    }
}

