/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.item;

import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.network.codec.NeoForgeStreamCodecs;
import net.p3pp3rf1y.sophisticatedcore.controller.ILinkable;
import net.p3pp3rf1y.sophisticatedcore.util.ItemBase;
import net.p3pp3rf1y.sophisticatedcore.util.RegistryHelper;
import net.p3pp3rf1y.sophisticatedcore.util.WorldHelper;
import net.p3pp3rf1y.sophisticatedstorage.block.ICountDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IFillLevelDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.ILockable;
import net.p3pp3rf1y.sophisticatedstorage.block.ITierDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.IUpgradeDisplay;
import net.p3pp3rf1y.sophisticatedstorage.block.StorageBlockEntity;
import net.p3pp3rf1y.sophisticatedstorage.client.gui.StorageTranslationHelper;
import net.p3pp3rf1y.sophisticatedstorage.init.ModBlocks;
import net.p3pp3rf1y.sophisticatedstorage.init.ModDataComponents;

public class StorageToolItem
extends ItemBase {
    public StorageToolItem() {
        super(new Item.Properties().stacksTo(1));
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag flag) {
        tooltipComponents.addAll(StorageTranslationHelper.INSTANCE.getTranslatedLines(stack.getItem().getDescriptionId() + ".tooltip", null, new ChatFormatting[]{ChatFormatting.DARK_GRAY}));
        String itemName = RegistryHelper.getItemKey((Item)stack.getItem()).getPath();
        tooltipComponents.add((Component)Component.translatable((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls"), (Object[])new Object[]{Component.translatable((String)(StorageTranslationHelper.INSTANCE.translItemTooltip(itemName) + ".controls.combination")).withStyle(ChatFormatting.AQUA)}).withStyle(ChatFormatting.GRAY));
    }

    public static void useOffHandOnPlaced(ItemStack tool, StorageBlockEntity be) {
        if (be.getLevel().isClientSide()) {
            return;
        }
        Mode mode = StorageToolItem.getMode(tool);
        if (mode == Mode.LINK) {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(be::linkToController, () -> ((StorageBlockEntity)be).unlinkFromController());
        } else if (mode == Mode.LOCK) {
            be.toggleLock();
        }
    }

    public InteractionResult onItemUseFirst(ItemStack tool, UseOnContext context) {
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        Block blockClicked = level.getBlockState(pos).getBlock();
        Mode mode = StorageToolItem.getMode(tool);
        switch (mode.ordinal()) {
            case 0: {
                if (!this.tryLinking(pos, level, blockClicked, tool)) break;
                return InteractionResult.SUCCESS;
            }
            case 1: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLock)) break;
                return InteractionResult.SUCCESS;
            }
            case 2: {
                if (!StorageToolItem.tryToggling(pos, level, ICountDisplay.class, ICountDisplay::toggleCountVisibility)) break;
                return InteractionResult.SUCCESS;
            }
            case 3: {
                if (!StorageToolItem.tryToggling(pos, level, ILockable.class, ILockable::toggleLockVisibility)) break;
                return InteractionResult.SUCCESS;
            }
            case 4: {
                if (!StorageToolItem.tryToggling(pos, level, ITierDisplay.class, ITierDisplay::toggleTierVisiblity)) break;
                return InteractionResult.SUCCESS;
            }
            case 5: {
                if (!StorageToolItem.tryToggling(pos, level, IUpgradeDisplay.class, IUpgradeDisplay::toggleUpgradesVisiblity)) break;
                return InteractionResult.SUCCESS;
            }
            case 6: {
                if (!StorageToolItem.tryToggling(pos, level, IFillLevelDisplay.class, IFillLevelDisplay::toggleFillLevelVisibility)) break;
                return InteractionResult.SUCCESS;
            }
        }
        return super.onItemUseFirst(tool, context);
    }

    private static <T> boolean tryToggling(BlockPos pos, Level level, Class<T> clazz, Consumer<T> toggle) {
        return WorldHelper.getLoadedBlockEntity((Level)level, (BlockPos)pos, clazz).map(be -> {
            if (level.isClientSide()) {
                return true;
            }
            toggle.accept(be);
            return true;
        }).orElse(false);
    }

    private boolean tryLinking(BlockPos pos, Level level, Block blockClicked, ItemStack tool) {
        if (blockClicked == ModBlocks.CONTROLLER.get()) {
            this.setControllerLink(tool, pos);
            return true;
        }
        return WorldHelper.getBlockEntity((BlockGetter)level, (BlockPos)pos, ILinkable.class).map(linkable -> {
            StorageToolItem.getControllerLink(tool).ifPresentOrElse(arg_0 -> ((ILinkable)linkable).linkToController(arg_0), () -> ((ILinkable)linkable).unlinkFromController());
            return true;
        }).orElse(false);
    }

    public InteractionResultHolder<ItemStack> use(Level level, Player player, InteractionHand usedHand) {
        ItemStack tool;
        if (player.isShiftKeyDown() && StorageToolItem.getControllerLink(tool = player.getItemInHand(usedHand)).isPresent()) {
            this.removeControllerLink(tool);
            return InteractionResultHolder.success((Object)tool);
        }
        return super.use(level, player, usedHand);
    }

    private void setControllerLink(ItemStack tool, BlockPos pos) {
        tool.set(ModDataComponents.CONTROLLER_POS, (Object)pos);
    }

    public static Optional<BlockPos> getControllerLink(ItemStack tool) {
        return Optional.ofNullable((BlockPos)tool.get(ModDataComponents.CONTROLLER_POS));
    }

    private void removeControllerLink(ItemStack tool) {
        tool.remove(ModDataComponents.CONTROLLER_POS);
    }

    public static Component getOverlayMessage(ItemStack tool) {
        Mode mode = StorageToolItem.getMode(tool);
        Item item = tool.getItem();
        return switch (mode.ordinal()) {
            default -> throw new MatchException(null, null);
            case 0 -> StorageToolItem.getControllerLink(tool).map(controllerPos -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "linking", controllerPos.getX(), controllerPos.getY(), controllerPos.getZ())).orElseGet(() -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "unlinking", new Object[0]));
            case 1 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock", new Object[0]);
            case 3 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_lock_display", new Object[0]);
            case 2 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_count_display", new Object[0]);
            case 4 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_tier_display", new Object[0]);
            case 5 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_upgrades_display", new Object[0]);
            case 6 -> StorageTranslationHelper.INSTANCE.translItemOverlayMessage(item, "toggling_fill_level_display", new Object[0]);
        };
    }

    public static Mode getMode(ItemStack tool) {
        return (Mode)((Object)tool.getOrDefault(ModDataComponents.TOOL_MODE, (Object)Mode.LINK));
    }

    public static void cycleMode(ItemStack tool, boolean next) {
        tool.set(ModDataComponents.TOOL_MODE, (Object)(next ? StorageToolItem.getMode(tool).next() : StorageToolItem.getMode(tool).previous()));
    }

    public static enum Mode implements StringRepresentable
    {
        LINK,
        LOCK,
        COUNT_DISPLAY,
        LOCK_DISPLAY,
        TIER_DISPLAY,
        UPGRADES_DISPLAY,
        FILL_LEVEL_DISPLAY;

        public static final StringRepresentable.EnumCodec<Mode> CODEC;
        public static final StreamCodec<FriendlyByteBuf, Mode> STREAM_CODEC;

        public Mode next() {
            return Mode.values()[(this.ordinal() + 1) % Mode.values().length];
        }

        public Mode previous() {
            return Mode.values()[Math.floorMod(this.ordinal() - 1, Mode.values().length)];
        }

        public String getSerializedName() {
            return this.name();
        }

        static {
            CODEC = StringRepresentable.fromEnum(Mode::values);
            STREAM_CODEC = NeoForgeStreamCodecs.enumCodec(Mode.class);
        }
    }
}

