/*
 * Decompiled with CFR 0.152.
 */
package net.p3pp3rf1y.sophisticatedstorage.block;

import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.neoforged.fml.util.thread.SidedThreadGroups;
import net.neoforged.neoforge.items.IItemHandlerModifiable;
import net.p3pp3rf1y.sophisticatedcore.api.IStorageWrapper;
import net.p3pp3rf1y.sophisticatedcore.common.gui.SortBy;
import net.p3pp3rf1y.sophisticatedcore.inventory.ITrackedContentsItemHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.InventoryIOHandler;
import net.p3pp3rf1y.sophisticatedcore.inventory.ItemStackKey;
import net.p3pp3rf1y.sophisticatedcore.renderdata.RenderInfo;
import net.p3pp3rf1y.sophisticatedcore.settings.SettingsHandler;
import net.p3pp3rf1y.sophisticatedcore.settings.itemdisplay.ItemDisplaySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.memory.MemorySettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.settings.nosort.NoSortSettingsCategory;
import net.p3pp3rf1y.sophisticatedcore.upgrades.IUpgradeWrapper;
import net.p3pp3rf1y.sophisticatedcore.upgrades.UpgradeHandler;
import net.p3pp3rf1y.sophisticatedcore.upgrades.stack.StackUpgradeItem;
import net.p3pp3rf1y.sophisticatedcore.util.InventorySorter;
import net.p3pp3rf1y.sophisticatedcore.util.NBTHelper;
import net.p3pp3rf1y.sophisticatedstorage.Config;
import net.p3pp3rf1y.sophisticatedstorage.init.ModItems;
import net.p3pp3rf1y.sophisticatedstorage.settings.StorageSettingsHandler;

public abstract class StorageWrapper
implements IStorageWrapper {
    public static final String MAIN_COLOR_TAG = "mainColor";
    public static final String ACCENT_COLOR_TAG = "accentColor";
    private static final String UUID_TAG = "uuid";
    private static final String OPEN_TAB_ID_TAG = "openTabId";
    public static final String CONTENTS_TAG = "contents";
    public static final String NUMBER_OF_INVENTORY_SLOTS_TAG = "numberOfInventorySlots";
    public static final String NUMBER_OF_UPGRADE_SLOTS_TAG = "numberOfUpgradeSlots";
    public static final String RENDER_INFO_TAG = "renderInfo";
    public static final String SORT_BY_TAG = "sortBy";
    private final Supplier<Runnable> getSaveHandler;
    @Nullable
    private InventoryHandler inventoryHandler = null;
    @Nullable
    private InventoryIOHandler inventoryIOHandler = null;
    @Nullable
    private UpgradeHandler upgradeHandler = null;
    private CompoundTag contentsNbt = new CompoundTag();
    private CompoundTag settingsNbt = new CompoundTag();
    private final SettingsHandler settingsHandler;
    private final RenderInfo renderInfo;
    private CompoundTag renderInfoNbt = new CompoundTag();
    @Nullable
    protected UUID contentsUuid = null;
    private int openTabId = -1;
    protected int numberOfInventorySlots = 0;
    protected int numberOfUpgradeSlots = -1;
    private SortBy sortBy = SortBy.NAME;
    private int columnsTaken = 0;
    private int mainColor = -1;
    private int accentColor = -1;
    private Runnable upgradeCachesInvalidatedHandler = () -> {};
    private final Map<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>> upgradeDefaultsHandlers = new HashMap<Class<? extends IUpgradeWrapper>, Consumer<? extends IUpgradeWrapper>>();
    private Runnable onInventoryForInputOutputHandlerRefresh = () -> {};

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, Runnable onSerializeRenderInfo, Runnable markContentsDirty) {
        this(getSaveHandler, onSerializeRenderInfo, markContentsDirty, 1, false);
    }

    protected StorageWrapper(Supplier<Runnable> getSaveHandler, final Runnable onSerializeRenderInfo, Runnable markContentsDirty, final int numberOfDisplayItems, boolean showsCountsAndFillRatios) {
        this.getSaveHandler = getSaveHandler;
        this.renderInfo = new RenderInfo(getSaveHandler, showsCountsAndFillRatios){

            protected void serializeRenderInfo(CompoundTag renderInfo) {
                StorageWrapper.this.renderInfoNbt = renderInfo;
                onSerializeRenderInfo.run();
            }

            protected Optional<CompoundTag> getRenderInfoTag() {
                return Optional.of(StorageWrapper.this.renderInfoNbt);
            }
        };
        this.settingsHandler = new StorageSettingsHandler(this, this.settingsNbt, markContentsDirty, this::getInventoryHandler, () -> this.renderInfo){

            @Override
            protected int getNumberOfDisplayItems() {
                return numberOfDisplayItems;
            }
        };
    }

    public void setContentsUuid(@Nullable UUID contentsUuid) {
        this.contentsUuid = contentsUuid;
    }

    public SettingsHandler getSettingsHandler() {
        return this.settingsHandler;
    }

    public UpgradeHandler getUpgradeHandler() {
        if (this.upgradeHandler == null) {
            this.upgradeHandler = new UpgradeHandler(this.getNumberOfUpgradeSlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), () -> {
                if (this.inventoryHandler != null) {
                    this.inventoryHandler.clearListeners();
                    this.inventoryHandler.setBaseSlotLimit(StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this));
                }
                this.getInventoryHandler().addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
                this.refreshInventoryForInputOutput();
                ((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class)).itemsChanged();
            }){

                public boolean isItemValid(int slot, ItemStack stack) {
                    return super.isItemValid(slot, stack) && (stack.isEmpty() || stack.is(ModItems.STORAGE_UPGRADE_TAG));
                }

                public void refreshUpgradeWrappers() {
                    super.refreshUpgradeWrappers();
                    StorageWrapper.this.onUpgradeRefresh();
                }
            };
            this.upgradeDefaultsHandlers.forEach(this::registerUpgradeDefaultsHandlerInUpgradeHandler);
        }
        return this.upgradeHandler;
    }

    private <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandlerInUpgradeHandler(Class<T> wrapperClass, Consumer<? extends IUpgradeWrapper> defaultsHandler) {
        this.upgradeHandler.registerUpgradeDefaultsHandler(wrapperClass, defaultsHandler);
    }

    public void setUpgradeCachesInvalidatedHandler(Runnable handler) {
        this.upgradeCachesInvalidatedHandler = handler;
    }

    protected abstract void onUpgradeRefresh();

    public CompoundTag save(CompoundTag tag) {
        this.saveContents(tag);
        this.saveData(tag);
        return tag;
    }

    private void saveContents(CompoundTag tag) {
        tag.put(CONTENTS_TAG, (Tag)this.getContentsNbt().copy());
    }

    CompoundTag saveData(CompoundTag tag) {
        if (!this.settingsNbt.isEmpty()) {
            tag.put("settings", (Tag)this.settingsNbt);
        }
        if (!this.renderInfoNbt.isEmpty()) {
            tag.put(RENDER_INFO_TAG, (Tag)this.renderInfoNbt);
        }
        if (this.contentsUuid != null) {
            tag.put(UUID_TAG, (Tag)NbtUtils.createUUID((UUID)this.contentsUuid));
        }
        if (this.openTabId >= 0) {
            tag.putInt(OPEN_TAB_ID_TAG, this.openTabId);
        }
        tag.putString(SORT_BY_TAG, this.sortBy.getSerializedName());
        if (this.columnsTaken > 0) {
            tag.putInt("columnsTaken", this.columnsTaken);
        }
        if (this.numberOfInventorySlots > 0) {
            tag.putInt(NUMBER_OF_INVENTORY_SLOTS_TAG, this.numberOfInventorySlots);
        }
        if (this.numberOfUpgradeSlots > -1) {
            tag.putInt(NUMBER_OF_UPGRADE_SLOTS_TAG, this.numberOfUpgradeSlots);
        }
        if (this.mainColor != -1) {
            tag.putInt(MAIN_COLOR_TAG, this.mainColor);
        }
        if (this.accentColor != -1) {
            tag.putInt(ACCENT_COLOR_TAG, this.accentColor);
        }
        return tag;
    }

    public void load(CompoundTag tag) {
        this.loadContents(tag);
        this.loadData(tag);
        if (this.inventoryHandler != null) {
            this.initInventoryHandler();
        }
        if (this.upgradeHandler != null) {
            this.getUpgradeHandler().refreshUpgradeWrappers();
        }
        if (Thread.currentThread().getThreadGroup() == SidedThreadGroups.SERVER && this.getRenderInfo().getUpgradeItems().size() != this.getUpgradeHandler().getSlots()) {
            this.getUpgradeHandler().setRenderUpgradeItems();
        }
    }

    private void loadData(CompoundTag tag) {
        this.settingsNbt = tag.getCompound("settings");
        this.settingsHandler.reloadFrom(this.settingsNbt);
        this.renderInfoNbt = tag.getCompound(RENDER_INFO_TAG);
        this.renderInfo.deserializeFrom(this.renderInfoNbt);
        this.contentsUuid = NBTHelper.getTagValue((CompoundTag)tag, (String)UUID_TAG, CompoundTag::get).map(NbtUtils::loadUUID).orElse(null);
        this.openTabId = NBTHelper.getInt((CompoundTag)tag, (String)OPEN_TAB_ID_TAG).orElse(-1);
        this.sortBy = NBTHelper.getString((CompoundTag)tag, (String)SORT_BY_TAG).map(SortBy::fromName).orElse(SortBy.NAME);
        this.columnsTaken = NBTHelper.getInt((CompoundTag)tag, (String)"columnsTaken").orElse(0);
        this.loadSlotNumbers(tag);
        this.mainColor = NBTHelper.getInt((CompoundTag)tag, (String)MAIN_COLOR_TAG).orElse(-1);
        this.accentColor = NBTHelper.getInt((CompoundTag)tag, (String)ACCENT_COLOR_TAG).orElse(-1);
    }

    protected void loadSlotNumbers(CompoundTag tag) {
        this.numberOfInventorySlots = NBTHelper.getInt((CompoundTag)tag, (String)NUMBER_OF_INVENTORY_SLOTS_TAG).orElse(0);
        this.numberOfUpgradeSlots = NBTHelper.getInt((CompoundTag)tag, (String)NUMBER_OF_UPGRADE_SLOTS_TAG).orElse(-1);
    }

    private void loadContents(CompoundTag tag) {
        if (tag.contains(CONTENTS_TAG)) {
            this.contentsNbt = tag.getCompound(CONTENTS_TAG);
            this.onContentsNbtUpdated();
        }
    }

    public void setContentsChangeHandler(Runnable contentsChangeHandler) {
    }

    public ITrackedContentsItemHandler getInventoryForUpgradeProcessing() {
        return this.getInventoryHandler();
    }

    public InventoryHandler getInventoryHandler() {
        if (this.inventoryHandler == null) {
            this.initInventoryHandler();
        }
        return this.inventoryHandler;
    }

    private void initInventoryHandler() {
        this.inventoryHandler = new InventoryHandler(this.getNumberOfInventorySlots(), this, this.getContentsNbt(), this.getSaveHandler.get(), StackUpgradeItem.getInventorySlotLimit((IStorageWrapper)this), Config.SERVER.stackUpgrade){

            protected boolean isAllowed(ItemStack stack) {
                return StorageWrapper.this.isAllowedInStorage(stack);
            }
        };
        this.inventoryHandler.addListener(arg_0 -> ((ItemDisplaySettingsCategory)((ItemDisplaySettingsCategory)this.getSettingsHandler().getTypeCategory(ItemDisplaySettingsCategory.class))).itemChanged(arg_0));
        this.inventoryHandler.setShouldInsertIntoEmpty(this::emptyInventorySlotsAcceptItems);
    }

    protected boolean emptyInventorySlotsAcceptItems() {
        return true;
    }

    protected CompoundTag getContentsNbt() {
        return this.contentsNbt;
    }

    public int getNumberOfInventorySlots() {
        if (this.numberOfInventorySlots > 0) {
            return this.numberOfInventorySlots;
        }
        this.numberOfInventorySlots = this.getDefaultNumberOfInventorySlots();
        this.save();
        return this.numberOfInventorySlots;
    }

    protected void save() {
        this.getSaveHandler.get().run();
    }

    public abstract int getDefaultNumberOfInventorySlots();

    protected abstract boolean isAllowedInStorage(ItemStack var1);

    public int getNumberOfSlotRows() {
        int itemInventorySlots = this.getNumberOfInventorySlots();
        return (int)Math.ceil(itemInventorySlots <= 81 ? (double)itemInventorySlots / 9.0 : (double)itemInventorySlots / 12.0);
    }

    public ITrackedContentsItemHandler getInventoryForInputOutput() {
        if (this.inventoryIOHandler == null) {
            this.inventoryIOHandler = new InventoryIOHandler((IStorageWrapper)this);
        }
        return this.inventoryIOHandler.getFilteredItemHandler();
    }

    private int getNumberOfUpgradeSlots() {
        if (this.numberOfUpgradeSlots >= this.getDefaultNumberOfUpgradeSlots()) {
            return this.numberOfUpgradeSlots;
        }
        this.numberOfUpgradeSlots = this.getDefaultNumberOfUpgradeSlots();
        this.save();
        return this.numberOfUpgradeSlots;
    }

    public abstract int getDefaultNumberOfUpgradeSlots();

    public int getMainColor() {
        return this.mainColor;
    }

    public boolean hasMainColor() {
        return this.mainColor != -1;
    }

    public int getAccentColor() {
        return this.accentColor;
    }

    public boolean hasAccentColor() {
        return this.accentColor != -1;
    }

    public Optional<Integer> getOpenTabId() {
        return this.openTabId >= 0 ? Optional.of(this.openTabId) : Optional.empty();
    }

    public void setOpenTabId(int openTabId) {
        this.openTabId = openTabId;
        this.save();
    }

    public void removeOpenTabId() {
        this.openTabId = -1;
        this.save();
    }

    public void setColors(int mainColor, int accentColor) {
        this.mainColor = mainColor;
        this.accentColor = accentColor;
        this.save();
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
        this.save();
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void sort() {
        HashSet slotIndexesExcludedFromSort = new HashSet();
        slotIndexesExcludedFromSort.addAll(((NoSortSettingsCategory)this.getSettingsHandler().getTypeCategory(NoSortSettingsCategory.class)).getNoSortSlots());
        slotIndexesExcludedFromSort.addAll(((MemorySettingsCategory)this.getSettingsHandler().getTypeCategory(MemorySettingsCategory.class)).getSlotIndexes());
        slotIndexesExcludedFromSort.addAll(this.getInventoryHandler().getNoSortSlots());
        InventorySorter.sortHandler((IItemHandlerModifiable)this.getInventoryHandler(), this.getComparator(), slotIndexesExcludedFromSort);
    }

    private Comparator<Map.Entry<ItemStackKey, Integer>> getComparator() {
        return switch (this.getSortBy()) {
            default -> throw new MatchException(null, null);
            case SortBy.COUNT -> InventorySorter.BY_COUNT;
            case SortBy.TAGS -> InventorySorter.BY_TAGS;
            case SortBy.NAME -> InventorySorter.BY_NAME;
            case SortBy.MOD -> InventorySorter.BY_MOD;
        };
    }

    public void onContentsNbtUpdated() {
        this.inventoryHandler = null;
        this.upgradeHandler = null;
        this.refreshInventoryForUpgradeProcessing();
    }

    public void refreshInventoryForUpgradeProcessing() {
        this.refreshInventoryForInputOutput();
    }

    public void refreshInventoryForInputOutput() {
        this.inventoryIOHandler = null;
        this.upgradeCachesInvalidatedHandler.run();
        this.onInventoryForInputOutputHandlerRefresh.run();
    }

    public void registerOnInventoryInputOutputHandlerRefreshListener(Runnable onInventoryForInputOutputHandlerRefresh) {
        this.onInventoryForInputOutputHandlerRefresh = onInventoryForInputOutputHandlerRefresh;
    }

    public void setPersistent(boolean persistent) {
    }

    public void fillWithLoot(Player playerEntity) {
    }

    public RenderInfo getRenderInfo() {
        return this.renderInfo;
    }

    public void setColumnsTaken(int columnsTaken, boolean hasChanged) {
        this.columnsTaken = columnsTaken;
        this.save();
    }

    public int getColumnsTaken() {
        return this.columnsTaken;
    }

    public void changeSize(int additionalInventorySlots, int additionalUpgradeSlots) {
        this.numberOfInventorySlots += additionalInventorySlots;
        this.getInventoryHandler().changeSlots(additionalInventorySlots);
        this.numberOfUpgradeSlots += additionalUpgradeSlots;
        this.getUpgradeHandler().increaseSize(additionalUpgradeSlots);
    }

    public <T extends IUpgradeWrapper> void registerUpgradeDefaultsHandler(Class<T> upgradeClass, Consumer<T> defaultsHandler) {
        this.upgradeDefaultsHandlers.put(upgradeClass, defaultsHandler);
    }
}

