/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.util;

import java.util.List;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.material.MapColor;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ColorUtils {
    public static final List<DyeColor> ORDERED_DYE_COLORS = List.of(DyeColor.WHITE, DyeColor.LIGHT_GRAY, DyeColor.GRAY, DyeColor.BLACK, DyeColor.BROWN, DyeColor.RED, DyeColor.ORANGE, DyeColor.YELLOW, DyeColor.LIME, DyeColor.GREEN, DyeColor.CYAN, DyeColor.LIGHT_BLUE, DyeColor.BLUE, DyeColor.PURPLE, DyeColor.MAGENTA, DyeColor.PINK);

    public static MapColor mapColorFromDye(@Nullable DyeColor dyeColor, @NotNull MapColor defaultColor) {
        if (dyeColor == null) {
            return defaultColor;
        }
        return ColorUtils.mapColorFromDye(dyeColor);
    }

    public static MapColor mapColorFromDye(@NotNull DyeColor dyeColor) {
        return switch (dyeColor) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> MapColor.TERRACOTTA_WHITE;
            case DyeColor.ORANGE -> MapColor.COLOR_ORANGE;
            case DyeColor.MAGENTA -> MapColor.COLOR_MAGENTA;
            case DyeColor.LIGHT_BLUE -> MapColor.COLOR_LIGHT_BLUE;
            case DyeColor.YELLOW -> MapColor.COLOR_YELLOW;
            case DyeColor.LIME -> MapColor.COLOR_LIGHT_GREEN;
            case DyeColor.PINK -> MapColor.COLOR_PINK;
            case DyeColor.GRAY -> MapColor.COLOR_GRAY;
            case DyeColor.LIGHT_GRAY -> MapColor.COLOR_LIGHT_GRAY;
            case DyeColor.CYAN -> MapColor.COLOR_CYAN;
            case DyeColor.PURPLE -> MapColor.COLOR_PURPLE;
            case DyeColor.BLUE -> MapColor.COLOR_BLUE;
            case DyeColor.BROWN -> MapColor.COLOR_BROWN;
            case DyeColor.GREEN -> MapColor.COLOR_GREEN;
            case DyeColor.RED -> MapColor.COLOR_RED;
            case DyeColor.BLACK -> MapColor.COLOR_BLACK;
        };
    }

    public static String coloredName(String string) {
        return switch (string) {
            case "white" -> "White";
            case "orange" -> "Orange";
            case "magenta" -> "Magenta";
            case "light_blue" -> "Light Blue";
            case "yellow" -> "Yellow";
            case "lime" -> "Lime";
            case "pink" -> "Pink";
            case "gray" -> "Gray";
            case "light_gray" -> "Light Gray";
            case "cyan" -> "Cyan";
            case "purple" -> "Purple";
            case "blue" -> "Blue";
            case "brown" -> "Brown";
            case "green" -> "Green";
            case "red" -> "Red";
            case "black" -> "Black";
            default -> "Unknown Color";
        };
    }

    public static Item getDyeColorDyeItem(DyeColor color) {
        return switch (color) {
            default -> throw new MatchException(null, null);
            case DyeColor.WHITE -> Items.WHITE_DYE;
            case DyeColor.ORANGE -> Items.ORANGE_DYE;
            case DyeColor.MAGENTA -> Items.MAGENTA_DYE;
            case DyeColor.LIGHT_BLUE -> Items.LIGHT_BLUE_DYE;
            case DyeColor.YELLOW -> Items.YELLOW_DYE;
            case DyeColor.LIME -> Items.LIME_DYE;
            case DyeColor.PINK -> Items.PINK_DYE;
            case DyeColor.GRAY -> Items.GRAY_DYE;
            case DyeColor.LIGHT_GRAY -> Items.LIGHT_GRAY_DYE;
            case DyeColor.CYAN -> Items.CYAN_DYE;
            case DyeColor.PURPLE -> Items.PURPLE_DYE;
            case DyeColor.BLUE -> Items.BLUE_DYE;
            case DyeColor.BROWN -> Items.BROWN_DYE;
            case DyeColor.GREEN -> Items.GREEN_DYE;
            case DyeColor.RED -> Items.RED_DYE;
            case DyeColor.BLACK -> Items.BLACK_DYE;
        };
    }
}

