/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.neoforge;

import com.mojang.authlib.GameProfile;
import com.railwayteam.railways.content.conductor.ConductorEntity;
import com.railwayteam.railways.content.conductor.IConductorHoldingFakePlayer;
import java.lang.ref.WeakReference;
import java.util.OptionalInt;
import net.minecraft.network.Connection;
import net.minecraft.network.PacketSendListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.Packet;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.server.network.CommonListenerCookie;
import net.minecraft.server.network.ServerGamePacketListenerImpl;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.util.FakePlayer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ConductorFakePlayerForge
extends FakePlayer
implements IConductorHoldingFakePlayer {
    private static final Connection NETWORK_MANAGER = new Connection(PacketFlow.CLIENTBOUND);
    private final WeakReference<ConductorEntity> conductor;

    public ConductorFakePlayerForge(ServerLevel level, ConductorEntity conductor) {
        super(level, ConductorEntity.FAKE_PLAYER_PROFILE);
        this.connection = new ConductorNetHandler(level.getServer(), (ServerPlayer)this);
        this.conductor = new WeakReference<ConductorEntity>(conductor);
    }

    @NotNull
    public OptionalInt openMenu(MenuProvider container) {
        return OptionalInt.empty();
    }

    @NotNull
    public Component getDisplayName() {
        return Component.translatable((String)"railways.conductor_name");
    }

    public Vec3 position() {
        return new Vec3(this.getX(), this.getY(), this.getZ());
    }

    public float getCurrentItemAttackStrengthDelay() {
        return 0.015625f;
    }

    public boolean canEat(boolean ignoreHunger) {
        return false;
    }

    @Override
    @Nullable
    public ConductorEntity getConductor() {
        return (ConductorEntity)((Object)this.conductor.get());
    }

    private static class ConductorNetHandler
    extends ServerGamePacketListenerImpl {
        public ConductorNetHandler(MinecraftServer server, ServerPlayer player) {
            super(server, NETWORK_MANAGER, player, CommonListenerCookie.createInitial((GameProfile)player.getGameProfile(), (boolean)false));
        }

        public void send(@NotNull Packet<?> packet) {
        }

        public void send(Packet<?> packet, @Nullable PacketSendListener listener) {
        }
    }
}

