/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.conductor_possession;

import com.railwayteam.railways.content.conductor.ClientHandler;
import com.railwayteam.railways.content.conductor.ConductorPossessionController;
import java.lang.reflect.Constructor;
import java.util.function.Consumer;
import net.minecraft.client.multiplayer.ClientChunkCache;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.game.ClientboundLevelChunkPacketData;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.chunk.LevelChunk;
import net.minecraft.world.level.chunk.status.ChunkStatus;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Slice;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientChunkCache.class}, priority=1200)
public abstract class ClientChunkCacheMixin {
    @Shadow
    @Final
    ClientLevel level;

    private Object newStorage(int viewDistance) {
        try {
            ClientChunkCacheMixin clientChunkCacheMixin = this;
            if (clientChunkCacheMixin instanceof ClientChunkCache) {
                ClientChunkCache cache = (ClientChunkCache)clientChunkCacheMixin;
                Class<?> storageClass = Class.forName("net.minecraft.client.multiplayer.ClientChunkCache$Storage");
                Constructor<?> ctor = storageClass.getDeclaredConstructor(ClientChunkCache.class, Integer.TYPE);
                ctor.setAccessible(true);
                return ctor.newInstance(cache, viewDistance);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    @Shadow
    private static boolean isValidChunk(LevelChunk chunk, int x, int z) {
        throw new IllegalStateException("Shadowing isValidChunk did not work!");
    }

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    public void railways$securitycraft$onInit(ClientLevel level, int viewDistance, CallbackInfo ci) {
        ConductorPossessionController.setCameraStorage(this.newStorage(Math.max(2, viewDistance) + 3));
    }

    @Inject(method={"updateViewRadius"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/multiplayer/ClientChunkCache$Storage;<init>(Lnet/minecraft/client/multiplayer/ClientChunkCache;I)V")})
    public void railways$securitycraft$onUpdateViewRadius(int viewDistance, CallbackInfo ci) {
        Object storage = this.newStorage(Math.max(2, viewDistance) + 3);
        if (storage != null) {
            ConductorPossessionController.setCameraStorage(storage);
        }
    }

    @Inject(method={"drop"}, at={@At(value="HEAD")})
    public void railways$securitycraft$onDrop(ChunkPos pos, CallbackInfo ci) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            return;
        }
    }

    @Inject(method={"replaceWithPacketData"}, at={@At(value="HEAD")}, cancellable=true)
    private void railways$securitycraft$onReplace(int x, int z, FriendlyByteBuf buffer, CompoundTag chunkTag, Consumer<ClientboundLevelChunkPacketData.BlockEntityTagOutput> tagOutputConsumer, CallbackInfoReturnable<LevelChunk> callback) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            return;
        }
    }

    @Inject(method={"getChunk(IILnet/minecraft/world/level/chunk/ChunkStatus;Z)Lnet/minecraft/world/level/chunk/LevelChunk;"}, slice={@Slice(from=@At(value="RETURN", ordinal=1))}, at={@At(value="RETURN")}, cancellable=true)
    private void railways$securitycraft$onGetChunk(int x, int z, ChunkStatus requiredStatus, boolean load, CallbackInfoReturnable<LevelChunk> callback) {
        if (ClientHandler.isPlayerMountedOnCamera()) {
            // empty if block
        }
    }
}

