/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackRenderer;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import net.createmod.catnip.data.Couple;
import net.createmod.catnip.data.Iterate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Position;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;

@Mixin(value={BezierConnection.class}, remap=false)
public abstract class MixinBezierConnectionClient
implements IMonorailBezier {
    private IMonorailBezier.MonorailAngles[] bakedMonorails;

    @Shadow
    public abstract int getSegmentCount();

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public IMonorailBezier.MonorailAngles[] getBakedMonorails() {
        if (this.bakedMonorails != null) {
            return this.bakedMonorails;
        }
        int segmentCount = this.getSegmentCount();
        this.bakedMonorails = new IMonorailBezier.MonorailAngles[segmentCount + 1];
        Couple previousOffsets = null;
        BezierConnection this_ = (BezierConnection)this;
        for (BezierConnection.Segment segment : this_) {
            int i = segment.index;
            boolean end = i == 0 || i == segmentCount;
            IMonorailBezier.MonorailAngles angles = this.bakedMonorails[i] = new IMonorailBezier.MonorailAngles();
            Vec3 mainGirder = segment.position;
            Vec3 upNormal = segment.derivative.normalize().cross(segment.normal);
            Vec3 firstGirderOffset = upNormal.scale(0.5);
            Vec3 secondGirderOffset = upNormal.scale(-0.625);
            Vec3 mainTop = segment.position.add(firstGirderOffset);
            Vec3 mainBottom = mainTop.add(secondGirderOffset);
            angles.lightPosition = BlockPos.containing((Position)mainGirder);
            Couple offsets = Couple.create((Object)mainTop, (Object)mainBottom);
            if (previousOffsets == null) {
                previousOffsets = offsets;
                continue;
            }
            angles.beam = null;
            angles.beamCaps = Couple.create(null, null);
            float scale = end ? 2.3f : 2.2f;
            Vec3 currentBeam = ((Vec3)offsets.getFirst()).add((Vec3)offsets.getSecond()).scale(0.5);
            Vec3 previousBeam = ((Vec3)previousOffsets.getFirst()).add((Vec3)previousOffsets.getSecond()).scale(0.5);
            Vec3 beamDiff = currentBeam.subtract(previousBeam);
            Vec3 beamAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)beamDiff);
            PoseStack poseStack = new PoseStack();
            ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)poseStack).translate(previousBeam)).rotateY((float)beamAngles.y)).rotateX((float)beamAngles.x)).rotateZ((float)beamAngles.z)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).scale(1.0f, 1.0f, (float)beamDiff.length() * scale);
            angles.beam = poseStack.last();
            for (boolean top : Iterate.trueAndFalse) {
                Vec3 current = (Vec3)offsets.get(top);
                Vec3 previous = (Vec3)previousOffsets.get(top);
                Vec3 diff = current.subtract(previous);
                Vec3 capAngles = TrackRenderer.getModelAngles((Vec3)segment.normal, (Vec3)diff);
                poseStack = new PoseStack();
                ((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)((PoseTransformStack)TransformStack.of((PoseStack)poseStack).translate(previous)).rotateY((float)capAngles.y)).rotateX((float)capAngles.x)).rotateZ((float)capAngles.z)).translate(0.0f, 0.125f + (float)(segment.index % 2 == 0 ? 1 : -1) / 2048.0f - 9.765625E-4f, -0.03125f).rotateZ(0.0f)).scale(1.0f, 1.0f, (float)diff.length() * scale);
                angles.beamCaps.set(top, (Object)poseStack.last());
            }
            previousOffsets = offsets;
        }
        return this.bakedMonorails;
    }
}

