/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.base.datafixers.CompatCherryTrackFix;
import net.minecraft.core.HolderGetter;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={NbtUtils.class})
public class NbtUtilsMixin {
    @Inject(method={"readBlockState"}, at={@At(value="HEAD")})
    private static void railways$upgradeBlocks(HolderGetter<Block> blockGetter, CompoundTag tag, CallbackInfoReturnable<BlockState> cir) {
        if (tag.contains("Name", 8)) {
            if (tag.getString("Name").equals("railways:mono_bogey_upside_down")) {
                tag.putString("Name", "railways:mono_bogey");
                CompoundTag properties = tag.getCompound("Properties");
                properties.putString("upside_down", "true");
                tag.put("Properties", (Tag)properties);
            }
            if (CompatCherryTrackFix.standardCherryOld.contains((Object)tag.getString("Name"))) {
                NbtUtilsMixin.railways$fixCherryTrackData(tag, "railways:track_cherry");
            } else if (CompatCherryTrackFix.wideCherryOld.contains((Object)tag.getString("Name"))) {
                NbtUtilsMixin.railways$fixCherryTrackData(tag, "railways:track_cherry_wide");
            } else if (CompatCherryTrackFix.narrowCherryOld.contains((Object)tag.getString("Name"))) {
                NbtUtilsMixin.railways$fixCherryTrackData(tag, "railways:track_cherry_narrow");
            }
        }
    }

    @Unique
    private static void railways$fixCherryTrackData(CompoundTag tag, String name) {
        tag.putString("Name", name);
        CompoundTag properties = tag.getCompound("Properties");
        tag.put("Properties", (Tag)properties);
    }
}

