/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.llamalad7.mixinextras.injector.wrapoperation.Operation;
import com.llamalad7.mixinextras.injector.wrapoperation.WrapOperation;
import com.railwayteam.railways.content.coupling.TrainUtils;
import com.railwayteam.railways.mixin.AccessorCarriageContraptionEntity;
import com.railwayteam.railways.mixin_interfaces.IHandcarTrain;
import com.railwayteam.railways.mixin_interfaces.IOccupiedCouplers;
import com.railwayteam.railways.mixin_interfaces.IUpdateCount;
import com.simibubi.create.content.trains.entity.Carriage;
import com.simibubi.create.content.trains.entity.Navigation;
import com.simibubi.create.content.trains.entity.Train;
import com.simibubi.create.content.trains.entity.TrainRelocator;
import com.simibubi.create.content.trains.track.BezierTrackPointLocation;
import java.util.ArrayDeque;
import java.util.Deque;
import net.createmod.catnip.data.Pair;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={TrainRelocator.class})
public class MixinTrainRelocator {
    @Unique
    private static final ThreadLocal<Deque<TrainStateSnapshot>> railways$preRelocateState = ThreadLocal.withInitial(ArrayDeque::new);

    @WrapOperation(method={"relocate"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;findCollidingTrain(Lnet/minecraft/world/level/Level;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/world/phys/Vec3;Lnet/minecraft/resources/ResourceKey;)Lnet/createmod/catnip/data/Pair;")})
    private static Pair<Train, Vec3> railways$ignoreCrashedTrainCollisions(Train train, Level level, Vec3 start, Vec3 end, ResourceKey<Level> dimension, Operation<Pair<Train, Vec3>> original) {
        Pair collision = (Pair)original.call(new Object[]{train, level, start, end, dimension});
        if (collision == null) {
            return null;
        }
        Train other = (Train)collision.getFirst();
        if (other == null) {
            return collision;
        }
        if (other.derailed || other.invalid || other.graph == null) {
            return null;
        }
        return collision;
    }

    @Inject(method={"relocate"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/entity/Train;collectInitiallyOccupiedSignalBlocks()V", shift=At.Shift.AFTER)})
    private static void tryToApproachStation(Train train, Level level, BlockPos pos, BezierTrackPointLocation bezier, boolean bezierDirection, Vec3 lookAngle, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (!(simulate || level.isClientSide || ((IHandcarTrain)train).railways$isHandcar())) {
            TrainUtils.tryToParkNearby(train, 1.25);
        }
    }

    @Inject(method={"relocate"}, at={@At(value="HEAD")})
    private static void railways$prepareRelocate(Train train, Level level, BlockPos pos, BezierTrackPointLocation bezier, boolean bezierDirection, Vec3 lookAngle, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (simulate || level.isClientSide) {
            return;
        }
        Deque<TrainStateSnapshot> stack = railways$preRelocateState.get();
        stack.push(new TrainStateSnapshot(train.derailed, train.invalid));
        train.derailed = false;
        train.invalid = false;
    }

    @Inject(method={"relocate"}, at={@At(value="RETURN")})
    private static void railways$finalizeRelocate(Train train, Level level, BlockPos pos, BezierTrackPointLocation bezier, boolean bezierDirection, Vec3 lookAngle, boolean simulate, CallbackInfoReturnable<Boolean> cir) {
        if (simulate || level.isClientSide) {
            return;
        }
        Deque<TrainStateSnapshot> stack = railways$preRelocateState.get();
        TrainStateSnapshot previous = stack.poll();
        if (stack.isEmpty()) {
            railways$preRelocateState.remove();
        }
        if (previous == null) {
            return;
        }
        if (Boolean.TRUE.equals(cir.getReturnValue())) {
            train.derailed = false;
            train.invalid = false;
            train.speed = 0.0;
            train.navigation = new Navigation(train);
            train.updateSignalBlocks = true;
            ((IOccupiedCouplers)train).railways$getOccupiedCouplers().clear();
            MixinTrainRelocator.railways$rebindCarriages(train);
        } else {
            train.derailed = previous.derailed();
            train.invalid = previous.invalid();
        }
    }

    @Unique
    private static void railways$rebindCarriages(Train train) {
        for (int index = 0; index < train.carriages.size(); ++index) {
            Carriage carriage = (Carriage)train.carriages.get(index);
            if (carriage == null) continue;
            int finalIndex = index;
            carriage.forEachPresentEntity(cce -> {
                cce.carriageIndex = finalIndex;
                cce.trainId = train.id;
                ((AccessorCarriageContraptionEntity)cce).railways$setCarriage(carriage);
                ((AccessorCarriageContraptionEntity)cce).railways$bindCarriage();
                ((IUpdateCount)cce).railways$markUpdate();
            });
        }
    }

    @Unique
    private record TrainStateSnapshot(boolean derailed, boolean invalid) {
    }
}

