/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin;

import com.railwayteam.railways.mixin_interfaces.ILimited;
import com.simibubi.create.Create;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.signal.TrackEdgePoint;
import com.simibubi.create.content.trains.station.GlobalStation;
import com.simibubi.create.content.trains.station.StationBlockEntity;
import com.simibubi.create.content.trains.station.StationEditPacket;
import net.minecraft.server.level.ServerPlayer;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={StationEditPacket.class}, remap=false)
public abstract class MixinStationEditPacket
implements ILimited {
    private Boolean limitEnabled;

    @Override
    public void setLimitEnabled(boolean limitEnabled) {
        this.limitEnabled = limitEnabled;
    }

    @Override
    public boolean isLimitEnabled() {
        return this.limitEnabled;
    }

    @Inject(method={"applySettings(Lnet/minecraft/server/level/ServerPlayer;Lcom/simibubi/create/content/trains/station/StationBlockEntity;)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/world/level/block/state/BlockState;getBlock()Lnet/minecraft/world/level/block/Block;")}, remap=true)
    private void applyLimit(ServerPlayer player, StationBlockEntity te, CallbackInfo ci) {
        if (this.limitEnabled != null) {
            GlobalStation station = te.getStation();
            TrackGraphLocation graphLocation = te.edgePoint.determineGraphLocation();
            if (station != null && graphLocation != null) {
                ((ILimited)station).setLimitEnabled(this.limitEnabled);
                Create.RAILWAYS.sync.pointAdded(graphLocation.graph, (TrackEdgePoint)station);
                Create.RAILWAYS.markTracksDirty();
            }
        }
    }
}

