/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.switches;

import com.mojang.blaze3d.vertex.PoseStack;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.switches.TrackSwitch;
import com.railwayteam.railways.content.switches.TrackSwitchBlock;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CREdgePointTypes;
import com.railwayteam.railways.registry.CRIcons;
import com.simibubi.create.api.contraption.transformable.TransformableBlockEntity;
import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.contraptions.StructureTransform;
import com.simibubi.create.content.trains.graph.TrackEdge;
import com.simibubi.create.content.trains.graph.TrackGraph;
import com.simibubi.create.content.trains.graph.TrackGraphLocation;
import com.simibubi.create.content.trains.graph.TrackNodeLocation;
import com.simibubi.create.content.trains.track.TrackTargetingBehaviour;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.ValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.ScrollOptionBehaviour;
import com.simibubi.create.foundation.gui.AllIcons;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import dev.engine_room.flywheel.lib.transform.PoseTransformStack;
import dev.engine_room.flywheel.lib.transform.TransformStack;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.lang.LangBuilder;
import net.createmod.catnip.math.AngleHelper;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.Vec3i;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackSwitchBlockEntity
extends SmartBlockEntity
implements TransformableBlockEntity,
IHaveGoggleInformation {
    public TrackTargetingBehaviour<TrackSwitch> edgePoint;
    private TrackSwitchBlock.SwitchState state;
    private int lastAnalogOutput = 0;
    private final boolean[] previousPower = new boolean[6];
    protected ScrollOptionBehaviour<AutoMode> autoMode;
    int exitCount = 0;
    @ApiStatus.Internal
    @Nullable
    public PonderData ponderData;
    final LerpedFloat lerpedAngle = LerpedFloat.angular().chase(0.0, 0.3, LerpedFloat.Chaser.EXP);
    private final int clientLazyTickRate = 10;
    private int clientLazyTickCounter = 0;

    @ApiStatus.Internal
    public void setStatePonder(TrackSwitchBlock.SwitchState state) {
        this.state = state;
    }

    @Nullable
    public TrackSwitch getSwitch() {
        return this.edgePoint == null ? null : (TrackSwitch)this.edgePoint.getEdgePoint();
    }

    public TrackSwitchBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
        this.edgePoint = new TrackTargetingBehaviour((SmartBlockEntity)this, CREdgePointTypes.SWITCH);
        behaviours.add((BlockEntityBehaviour)this.edgePoint);
        if (this.isAutomatic()) {
            this.autoMode = new ScrollOptionBehaviour(AutoMode.class, (Component)Component.translatable((String)"railways.switch.auto_mode"), (SmartBlockEntity)this, new ValueBoxTransform(this){

                public Vec3 getLocalOffset(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState) {
                    Vec3 base = new Vec3(0.75, 0.28125, 0.25);
                    base = VecHelper.rotateCentered((Vec3)base, (double)AngleHelper.horizontalAngle((Direction)((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING))), (Direction.Axis)Direction.Axis.Y);
                    return base;
                }

                public void rotate(LevelAccessor levelAccessor, BlockPos blockPos, BlockState blockState, PoseStack ms) {
                    ((PoseTransformStack)TransformStack.of((PoseStack)ms).rotateYDegrees(AngleHelper.horizontalAngle((Direction)((Direction)blockState.getValue((Property)HorizontalDirectionalBlock.FACING))) - 90.0f)).rotateXDegrees(90.0f);
                }

                public boolean testHit(LevelAccessor level, BlockPos pos, BlockState state, Vec3 localHit) {
                    Vec3 offset = this.getLocalOffset(level, pos, state);
                    if (offset == null) {
                        return false;
                    }
                    return localHit.distanceTo(offset) < (double)(this.scale / 3.0f);
                }
            });
            this.autoMode.withCallback(ordinal -> {
                AutoMode mode = AutoMode.values()[ordinal];
                TrackSwitch sw = this.getSwitch();
                if (sw != null) {
                    sw.setAutoTrainsSwitch(mode == AutoMode.AUTO);
                }
            });
            this.autoMode.requiresWrench();
            behaviours.add((BlockEntityBehaviour)this.autoMode);
        }
    }

    public void transform(BlockEntity blockEntity, StructureTransform structureTransform) {
        this.edgePoint.transform(blockEntity, structureTransform);
    }

    public boolean isAutomatic() {
        Block block = this.getBlockState().getBlock();
        if (block instanceof TrackSwitchBlock) {
            TrackSwitchBlock block2 = (TrackSwitchBlock)block;
            return block2.isAutomatic;
        }
        return false;
    }

    public boolean isLocked() {
        return (Boolean)this.getBlockState().getValue((Property)TrackSwitchBlock.LOCKED);
    }

    private void enterState(TrackSwitchBlock.SwitchState state) {
        if (this.state == state) {
            return;
        }
        this.state = state;
        this.notifyUpdate();
    }

    @NotNull
    public TrackSwitchBlock.SwitchState getState() {
        return this.state == null ? TrackSwitchBlock.SwitchState.NORMAL : this.state;
    }

    public boolean isNormal() {
        return this.getState() == TrackSwitchBlock.SwitchState.NORMAL;
    }

    public boolean isReverseLeft() {
        return this.getState() == TrackSwitchBlock.SwitchState.REVERSE_LEFT;
    }

    public boolean isReverseRight() {
        return this.getState() == TrackSwitchBlock.SwitchState.REVERSE_RIGHT;
    }

    public boolean hasExit(TrackSwitchBlock.SwitchState state) {
        TrackSwitch sw = this.getSwitch();
        if (sw == null) {
            return false;
        }
        return switch (state) {
            default -> throw new MatchException(null, null);
            case TrackSwitchBlock.SwitchState.NORMAL -> sw.hasStraightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> sw.hasRightExit();
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> sw.hasLeftExit();
        };
    }

    public PartialModel getOverlayModel() {
        TrackSwitch sw = (TrackSwitch)this.edgePoint.getEdgePoint();
        if (sw == null) {
            return null;
        }
        if (sw.hasStraightExit() && sw.hasLeftExit() && sw.hasRightExit()) {
            if (this.isNormal()) {
                return CRBlockPartials.SWITCH_3WAY_STRAIGHT;
            }
            if (this.isReverseLeft()) {
                return CRBlockPartials.SWITCH_3WAY_LEFT;
            }
            if (this.isReverseRight()) {
                return CRBlockPartials.SWITCH_3WAY_RIGHT;
            }
        } else {
            if (sw.hasStraightExit() && sw.hasLeftExit()) {
                return this.isNormal() ? CRBlockPartials.SWITCH_LEFT_STRAIGHT : CRBlockPartials.SWITCH_LEFT_TURN;
            }
            if (sw.hasStraightExit() && sw.hasRightExit()) {
                return this.isNormal() ? CRBlockPartials.SWITCH_RIGHT_STRAIGHT : CRBlockPartials.SWITCH_RIGHT_TURN;
            }
            if (sw.hasLeftExit() && sw.hasRightExit()) {
                return this.isReverseLeft() ? CRBlockPartials.SWITCH_2WAY_LEFT : CRBlockPartials.SWITCH_2WAY_RIGHT;
            }
        }
        return CRBlockPartials.SWITCH_NONE;
    }

    void calculateExits(TrackSwitch sw) {
        TrackGraphLocation loc;
        try {
            loc = this.edgePoint.determineGraphLocation();
        }
        catch (ClassCastException ignored) {
            return;
        }
        if (loc == null) {
            return;
        }
        TrackGraph graph = loc.graph;
        TrackEdge edge = (TrackEdge)graph.getConnectionsFrom(graph.locateNode((TrackNodeLocation)loc.edge.getFirst())).get(graph.locateNode((TrackNodeLocation)loc.edge.getSecond()));
        Set<TrackNodeLocation> exits = graph.getConnectionsFrom(edge.node2).values().stream().filter(e -> e != edge).filter(e -> !e.node1.getLocation().equals((Object)edge.node2.getLocation()) || !e.node2.getLocation().equals((Object)edge.node1.getLocation())).map(e -> e.node2.getLocation()).collect(Collectors.toSet());
        if (Math.abs(loc.position - (edge.getLength() - 0.5)) > 0.5) {
            exits = Set.of();
        }
        sw.updateExits(edge.node2.getLocation(), exits);
    }

    private static LangBuilder b() {
        return Lang.builder((String)"railways");
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        TrackSwitchBlockEntity.b().translate("tooltip.switch.header", new Object[0]).forGoggles(tooltip);
        TrackSwitchBlockEntity.b().translate("tooltip.switch.state", new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        TrackSwitchBlockEntity.b().translate("switch.state." + this.getState().getSerializedName(), new Object[0]).style(ChatFormatting.YELLOW).forGoggles(tooltip);
        return true;
    }

    public void tick() {
        super.tick();
        if (this.level != null) {
            TrackSwitch sw = this.getSwitch();
            if (sw != null) {
                sw.setLocked(this.isLocked());
            }
            if (this.level.isClientSide) {
                if (sw != null) {
                    sw.setSwitchState(this.state);
                    this.exitCount = sw.getExits().size();
                }
                this.lerpedAngle.tickChaser();
                ++this.clientLazyTickCounter;
                if (this.clientLazyTickCounter >= 10 || sw != null && sw.doForceTickClient()) {
                    this.clientLazyTick();
                    this.clientLazyTickCounter = 0;
                }
            } else {
                if (sw == null) {
                    this.enterState(TrackSwitchBlock.SwitchState.NORMAL);
                    return;
                }
                this.enterState(sw.getSwitchState());
                if (this.getTargetAnalogOutput() != this.lastAnalogOutput) {
                    this.lastAnalogOutput = this.getTargetAnalogOutput();
                    this.level.updateNeighbourForOutputSignal(this.getBlockPos(), this.getBlockState().getBlock());
                }
            }
        }
        this.checkRedstoneInputs();
    }

    boolean cycleState() {
        return this.cycleState(TrackSwitchBlock.SwitchConstraint.NONE);
    }

    boolean cycleState(TrackSwitchBlock.SwitchConstraint constraint) {
        TrackSwitchBlock.SwitchState oldState = this.getState();
        TrackSwitch sw = this.getSwitch();
        if (sw == null) {
            return false;
        }
        TrackSwitchBlock.SwitchState newState = oldState.nextStateFor(sw, constraint);
        if (oldState != newState) {
            return sw.setSwitchState(newState);
        }
        return false;
    }

    InteractionResult onUse(boolean reverseDirection) {
        if (!this.isLocked()) {
            this.cycleState(reverseDirection ? TrackSwitchBlock.SwitchConstraint.TO_LEFT : TrackSwitchBlock.SwitchConstraint.TO_RIGHT);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.CONSUME;
    }

    boolean onProjectileHit() {
        if (!this.isLocked()) {
            this.cycleState();
            return true;
        }
        return false;
    }

    private boolean hasSignal(Direction direction) {
        if (direction != Direction.UP && direction != Direction.DOWN) {
            direction = Direction.from2DDataValue((int)(direction.get2DDataValue() + ((Direction)this.getBlockState().getValue((Property)HorizontalDirectionalBlock.FACING)).get2DDataValue()));
        }
        return this.getLevel() != null && this.getLevel().hasSignal(this.getBlockPos().relative(direction), direction);
    }

    private boolean hasNewSignal(Direction direction) {
        return this.hasNewSignal(direction, true);
    }

    private boolean hasNewSignal(Direction direction, boolean updatePreviousPower) {
        boolean ret;
        int i = direction.ordinal();
        boolean powered = this.hasSignal(direction);
        boolean bl = ret = !this.previousPower[i] && powered;
        if (updatePreviousPower) {
            this.previousPower[i] = powered;
        }
        return ret;
    }

    void checkRedstoneInputs() {
        TrackSwitch sw;
        BlockState state = this.getBlockState();
        Level level = this.getLevel();
        BlockPos pos = this.getBlockPos();
        boolean alreadyLocked = this.isLocked();
        boolean shouldLock = this.hasSignal(Direction.DOWN);
        if (shouldLock ^ alreadyLocked) {
            level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)TrackSwitchBlock.LOCKED, (Comparable)Boolean.valueOf(shouldLock)));
            sw = this.getSwitch();
            if (sw != null) {
                sw.setLocked(shouldLock);
            }
        }
        if ((sw = this.getSwitch()) == null) {
            return;
        }
        if (this.hasNewSignal(Direction.EAST) || this.hasNewSignal(Direction.WEST)) {
            sw.setSwitchState(TrackSwitchBlock.SwitchState.NORMAL);
        } else if (this.hasNewSignal(Direction.NORTH)) {
            sw.setSwitchState(TrackSwitchBlock.SwitchState.REVERSE_RIGHT);
        } else if (this.hasNewSignal(Direction.SOUTH)) {
            sw.setSwitchState(TrackSwitchBlock.SwitchState.REVERSE_LEFT);
        } else if (this.hasNewSignal(Direction.UP)) {
            this.cycleState();
        }
    }

    public void clientLazyTick() {
        try {
            if (this.getSwitch() != null && this.edgePoint.determineGraphLocation() != null) {
                this.getSwitch().updateEdges(this.edgePoint.determineGraphLocation().graph);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    protected void restoreEdges() {
        try {
            if (this.edgePoint.getEdgePoint() != null && this.edgePoint.determineGraphLocation() != null) {
                ((TrackSwitch)this.edgePoint.getEdgePoint()).setEdgesActive(this.edgePoint.determineGraphLocation().graph);
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
    }

    public void remove() {
        super.remove();
        this.restoreEdges();
    }

    public void destroy() {
        this.restoreEdges();
        super.destroy();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.getSwitch() != null) {
            this.calculateExits(this.getSwitch());
        }
    }

    protected void write(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(tag, lookupProvider, clientPacket);
        if (clientPacket) {
            tag.putString("SwitchState", (this.state == null ? TrackSwitchBlock.SwitchState.NORMAL : this.state).getSerializedName());
        }
        tag.putInt("AnalogOutput", this.lastAnalogOutput);
        byte previousPowerState = 0;
        for (int i = 0; i < 6; ++i) {
            previousPowerState = (byte)(previousPowerState | (this.previousPower[i] ? 1 : 0) << i);
        }
        tag.putByte("PreviousPowerState", previousPowerState);
    }

    protected void read(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(tag, lookupProvider, clientPacket);
        if (clientPacket) {
            String switchState = tag.getString("SwitchState").toUpperCase(Locale.ROOT);
            try {
                this.state = TrackSwitchBlock.SwitchState.valueOf(switchState);
            }
            catch (IllegalArgumentException e) {
                Railways.LOGGER.error("Failed to read SwitchState", (Throwable)e);
            }
        }
        this.lastAnalogOutput = tag.getInt("AnalogOutput");
        byte previousPowerState = tag.getByte("PreviousPowerState");
        for (int i = 0; i < 6; ++i) {
            this.previousPower[i] = (previousPowerState & 1 << i) != 0;
        }
    }

    public int getTargetAnalogOutput() {
        if (this.state == null) {
            return 0;
        }
        return switch (this.state) {
            default -> throw new MatchException(null, null);
            case TrackSwitchBlock.SwitchState.NORMAL -> 0;
            case TrackSwitchBlock.SwitchState.REVERSE_LEFT -> 1;
            case TrackSwitchBlock.SwitchState.REVERSE_RIGHT -> 2;
        };
    }

    protected AABB createRenderBoundingBox() {
        return new AABB(Vec3.atCenterOf((Vec3i)this.worldPosition), Vec3.atCenterOf((Vec3i)this.edgePoint.getGlobalPosition())).inflate(2.0);
    }

    static enum AutoMode implements INamedIconOptions
    {
        MANUAL_ONLY(CRIcons.I_SWITCH_MANUAL),
        AUTO(CRIcons.I_SWITCH_AUTO);

        private final String translationKey;
        private final AllIcons icon;

        private AutoMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "railways.switch.auto_mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }
    }

    public record PonderData(Vec3 basePos, @Nullable Vec3 leftBranch, @Nullable Vec3 straightBranch, @Nullable Vec3 rightBranch) {
        Map<TrackSwitchBlock.SwitchState, Vec3> getBranches() {
            HashMap<TrackSwitchBlock.SwitchState, Vec3> branches = new HashMap<TrackSwitchBlock.SwitchState, Vec3>();
            if (this.leftBranch != null) {
                branches.put(TrackSwitchBlock.SwitchState.REVERSE_LEFT, this.leftBranch);
            }
            if (this.straightBranch != null) {
                branches.put(TrackSwitchBlock.SwitchState.NORMAL, this.straightBranch);
            }
            if (this.rightBranch != null) {
                branches.put(TrackSwitchBlock.SwitchState.REVERSE_RIGHT, this.rightBranch);
            }
            return branches;
        }
    }
}

