/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.semaphore;

import com.railwayteam.railways.config.CRConfigs;
import com.railwayteam.railways.content.distant_signals.IOverridableSignal;
import com.railwayteam.railways.content.semaphore.SemaphoreBlock;
import com.railwayteam.railways.multiloader.PlayerSelection;
import com.railwayteam.railways.multiloader.S2CPacket;
import com.railwayteam.railways.registry.CRIcons;
import com.railwayteam.railways.registry.CRPackets;
import com.railwayteam.railways.registry.CRTags;
import com.railwayteam.railways.util.packet.OverridableSignalPacket;
import com.simibubi.create.content.trains.signal.SignalBlock;
import com.simibubi.create.content.trains.signal.SignalBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.CenteredSideValueBoxTransform;
import com.simibubi.create.foundation.blockEntity.behaviour.scrollValue.INamedIconOptions;
import com.simibubi.create.foundation.gui.AllIcons;
import java.lang.ref.WeakReference;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.LerpedFloat;
import net.createmod.catnip.lang.Lang;
import net.createmod.catnip.math.VecHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;

public class SemaphoreBlockEntity
extends SmartBlockEntity
implements IOverridableSignal {
    private WeakReference<SignalBlockEntity> cachedSignalTE = new WeakReference<Object>(null);
    public SignalBlockEntity.SignalState signalState;
    public final LerpedFloat armPosition = LerpedFloat.linear().startWithValue(0.0);
    public boolean isValid = false;
    public boolean isDistantSignal = false;
    protected boolean cachedWasUpsideDown = false;
    private int overrideLastingTicks = -1;

    public SemaphoreBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
        this.setLazyTickRate(10);
    }

    public boolean wasCachedSearchingUpsideDown() {
        return this.cachedWasUpsideDown;
    }

    protected void read(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.read(tag, lookupProvider, clientPacket);
        this.cachedWasUpsideDown = tag.getBoolean("CachedWasUpsideDown");
    }

    protected void write(CompoundTag tag, HolderLookup.Provider lookupProvider, boolean clientPacket) {
        super.write(tag, lookupProvider, clientPacket);
        tag.putBoolean("CachedWasUpsideDown", this.cachedWasUpsideDown);
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviours) {
    }

    public void tick() {
        boolean target;
        super.tick();
        if (!this.level.isClientSide) {
            return;
        }
        if (this.overrideLastingTicks > 0) {
            boolean target2;
            --this.overrideLastingTicks;
            SignalBlockEntity signalBE = (SignalBlockEntity)this.cachedSignalTE.get();
            if (signalBE != null && !signalBE.isRemoved()) {
                this.signalState = signalBE.getState();
            }
            this.isValid = this.signalState != SignalBlockEntity.SignalState.INVALID;
            boolean isActive = false;
            if (this.isValid) {
                isActive = this.signalState == SignalBlockEntity.SignalState.YELLOW && !this.isDistantSignal || this.signalState == SignalBlockEntity.SignalState.GREEN;
            }
            float currentTarget = this.armPosition.getChaseTarget();
            boolean bl = target2 = isActive;
            if ((float)target2 != currentTarget) {
                this.armPosition.setValue((double)currentTarget);
                this.armPosition.chase((double)target2, (double)0.05f, LerpedFloat.Chaser.LINEAR);
            }
            this.armPosition.tickChaser();
            return;
        }
        if (this.overrideLastingTicks == 0) {
            --this.overrideLastingTicks;
            this.cachedSignalTE.clear();
            this.signalState = null;
            this.updateSignalConnection();
        }
        SignalBlockEntity signalBlockEntity = (SignalBlockEntity)this.cachedSignalTE.get();
        boolean isActive = false;
        if (signalBlockEntity != null && !signalBlockEntity.isRemoved() && this.isValid) {
            this.signalState = signalBlockEntity.getState();
            if (this.signalState == SignalBlockEntity.SignalState.INVALID) {
                this.isValid = false;
            } else {
                isActive = this.signalState == SignalBlockEntity.SignalState.YELLOW && !this.isDistantSignal || this.signalState == SignalBlockEntity.SignalState.GREEN;
            }
        }
        float currentTarget = this.armPosition.getChaseTarget();
        boolean bl = target = isActive;
        if ((float)target != currentTarget) {
            this.armPosition.setValue((double)currentTarget);
            this.armPosition.chase((double)target, (double)0.05f, LerpedFloat.Chaser.LINEAR);
        }
        this.armPosition.tickChaser();
    }

    public void lazyTick() {
        super.lazyTick();
        if (this.overrideLastingTicks > 0) {
            return;
        }
        this.signalState = null;
        this.updateSignalConnection();
    }

    boolean updateSignalConnection() {
        if (this.updateSignalConnection(this.cachedWasUpsideDown)) {
            return true;
        }
        if (this.updateSignalConnection(!this.cachedWasUpsideDown)) {
            this.cachedWasUpsideDown = !this.cachedWasUpsideDown;
            return true;
        }
        return false;
    }

    boolean updateSignalConnection(boolean upsideDown) {
        this.isValid = false;
        this.isDistantSignal = false;
        BlockPos currentPos = upsideDown ? this.worldPosition.above() : this.worldPosition.below();
        int semaphoresBelow = 0;
        boolean constantOrder = (Boolean)this.getBlockState().getValue((Property)SemaphoreBlock.UPSIDE_DOWN) == false || (Boolean)CRConfigs.server().semaphores.flipYellowOrder.get() == false;
        block0: for (int i = 0; i < 16; ++i) {
            BlockState blockState = this.level.getBlockState(currentPos);
            BlockEntity blockEntity = this.level.getBlockEntity(currentPos);
            if (blockEntity instanceof SignalBlockEntity) {
                SignalBlockEntity signal = (SignalBlockEntity)blockEntity;
                this.signalState = signal.getState();
                this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signal);
                this.isValid = true;
                SignalBlock.SignalType stateType = (SignalBlock.SignalType)blockState.getValue((Property)SignalBlock.TYPE);
                if (semaphoresBelow == 0 == (upsideDown && constantOrder)) break;
                currentPos = upsideDown ? (constantOrder ? currentPos : this.worldPosition).below() : this.worldPosition.above();
                for (int j = i + 1; j < 16; ++j) {
                    SemaphoreBlockEntity semaphore;
                    blockState = this.level.getBlockState(currentPos);
                    blockEntity = this.level.getBlockEntity(currentPos);
                    if (blockEntity instanceof SemaphoreBlockEntity && (semaphore = (SemaphoreBlockEntity)blockEntity).wasCachedSearchingUpsideDown() == this.wasCachedSearchingUpsideDown()) {
                        this.isDistantSignal = true;
                        break block0;
                    }
                    if (!CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState)) break block0;
                    currentPos = upsideDown ? currentPos.below() : currentPos.above();
                }
                break;
            }
            if (!(blockEntity instanceof SemaphoreBlockEntity) ? !CRTags.AllBlockTags.SEMAPHORE_POLES.matches(blockState) : ++semaphoresBelow > 1) break;
            currentPos = upsideDown ? currentPos.above() : currentPos.below();
        }
        return this.isValid;
    }

    @Override
    public void railways$refresh(@Nullable SignalBlockEntity signalBE, SignalBlockEntity.SignalState state, int ticks, boolean distantSignal) {
        if (this.level == null) {
            return;
        }
        this.cachedSignalTE = new WeakReference<SignalBlockEntity>(signalBE);
        this.signalState = state;
        this.overrideLastingTicks = ticks;
        this.isDistantSignal = distantSignal;
        if (!this.level.isClientSide) {
            CRPackets.PACKETS.sendTo(PlayerSelection.tracking((BlockEntity)this), (S2CPacket)new OverridableSignalPacket(this.getBlockPos(), signalBE == null ? null : signalBE.getBlockPos(), state, ticks, distantSignal));
        }
    }

    @Override
    public Optional<SignalBlockEntity.SignalState> railways$getOverriddenState() {
        if (this.overrideLastingTicks > 0 && this.signalState != null) {
            return Optional.of(this.signalState);
        }
        return Optional.empty();
    }

    public static enum SearchMode implements INamedIconOptions
    {
        SEARCH_DOWN(CRIcons.I_SEARCH_DOWN),
        SEARCH_UP(CRIcons.I_SEARCH_UP);

        private final String translationKey;
        private final AllIcons icon;

        private SearchMode(AllIcons icon) {
            this.icon = icon;
            this.translationKey = "railways.semaphore.search_mode." + Lang.asId((String)this.name());
        }

        public AllIcons getIcon() {
            return this.icon;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public boolean isUpsideDown() {
            return this == SEARCH_UP;
        }

        public static SearchMode fromUpsideDown(boolean upsideDown) {
            return upsideDown ? SEARCH_UP : SEARCH_DOWN;
        }
    }

    private static class SemaphoreValueBoxTransform
    extends CenteredSideValueBoxTransform {
        public SemaphoreValueBoxTransform() {
            super((state, d) -> {
                if (d.getAxis().isVertical()) {
                    return false;
                }
                boolean flipped = (Boolean)state.getValue((Property)SemaphoreBlock.FLIPPED);
                Direction facing = (Direction)state.getValue((Property)SemaphoreBlock.FACING);
                return d == facing || facing.getCounterClockWise() == (flipped ? d.getOpposite() : d);
            });
        }

        protected Vec3 getSouthLocation() {
            return VecHelper.voxelSpace((double)8.0, (double)8.0, (double)11.0);
        }
    }
}

