/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.palettes.boiler;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import com.railwayteam.railways.content.palettes.boiler.neoforge.BoilerBlockPlacementHelperImpl;
import com.railwayteam.railways.mixin_interfaces.IHasCustomOutline;
import com.railwayteam.railways.registry.CRShapes;
import com.simibubi.create.content.equipment.wrench.IWrenchable;
import com.simibubi.create.foundation.block.IHaveBigOutline;
import com.simibubi.create.foundation.placement.PoleHelper;
import com.simibubi.create.infrastructure.config.AllConfigs;
import java.util.List;
import java.util.Locale;
import java.util.function.Predicate;
import net.createmod.catnip.data.Iterate;
import net.createmod.catnip.placement.IPlacementHelper;
import net.createmod.catnip.placement.PlacementHelpers;
import net.createmod.catnip.placement.PlacementOffset;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Holder;
import net.minecraft.core.Vec3i;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.ItemInteractionResult;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BoilerBlock
extends Block
implements IWrenchable,
IHasCustomOutline,
IHaveBigOutline {
    public static final int placementHelperId = PlacementHelpers.register((IPlacementHelper)new PlacementHelper());
    public static final EnumProperty<Style> STYLE = EnumProperty.create((String)"style", Style.class);
    public static final EnumProperty<Direction.Axis> HORIZONTAL_AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final BooleanProperty RAISED = BooleanProperty.create((String)"raised");

    public BoilerBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)((BlockState)this.defaultBlockState().setValue(STYLE, (Comparable)((Object)Style.GULLET))).setValue(HORIZONTAL_AXIS, (Comparable)Direction.Axis.X)).setValue((Property)RAISED, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{STYLE, HORIZONTAL_AXIS, RAISED});
    }

    public BlockState getRotatedBlockState(BlockState originalState, Direction targetedFace) {
        if (targetedFace.getAxis() == originalState.getValue(HORIZONTAL_AXIS)) {
            return (BlockState)originalState.cycle(STYLE);
        }
        return super.getRotatedBlockState(originalState, targetedFace);
    }

    public boolean skipRendering(@NotNull BlockState state, BlockState adjacentBlockState, @NotNull Direction direction) {
        return adjacentBlockState.is((Block)this) && adjacentBlockState.getValue(HORIZONTAL_AXIS) == state.getValue(HORIZONTAL_AXIS) && adjacentBlockState.getValue((Property)RAISED) == state.getValue((Property)RAISED);
    }

    @NotNull
    public VoxelShape getOcclusionShape(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return Shapes.empty();
    }

    public float getShadeBrightness(@NotNull BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return 1.0f;
    }

    @NotNull
    public BlockState rotate(@NotNull BlockState state, Rotation rotation) {
        return switch (rotation) {
            case Rotation.COUNTERCLOCKWISE_90, Rotation.CLOCKWISE_90 -> (BlockState)state.cycle(HORIZONTAL_AXIS);
            default -> state;
        };
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext context) {
        boolean raised = context.getPlayer() != null && context.getPlayer().isShiftKeyDown();
        Direction.Axis axis = context.getClickedFace().getAxis();
        if (axis == Direction.Axis.Y) {
            axis = context.getHorizontalDirection().getAxis();
        }
        return (BlockState)((BlockState)this.defaultBlockState().setValue(HORIZONTAL_AXIS, (Comparable)axis)).setValue((Property)RAISED, (Comparable)Boolean.valueOf(raised));
    }

    public ItemInteractionResult useItemOn(ItemStack stack, @NotNull BlockState state, @NotNull Level level, @NotNull BlockPos pos, Player player, @NotNull InteractionHand hand, @NotNull BlockHitResult hit) {
        if (player.isShiftKeyDown() || !player.mayBuild()) {
            return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        IPlacementHelper helper = PlacementHelpers.get((int)placementHelperId);
        if (helper.matchesItem(stack)) {
            ItemInteractionResult result = helper.getOffset(player, level, state, pos, hit).placeInWorld(level, (BlockItem)stack.getItem(), player, hand, hit);
            return result.consumesAction() ? result : ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
        }
        return ItemInteractionResult.PASS_TO_DEFAULT_BLOCK_INTERACTION;
    }

    @NotNull
    public VoxelShape getShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape getCollisionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos, @NotNull CollisionContext context) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape getInteractionShape(BlockState state, @NotNull BlockGetter level, @NotNull BlockPos pos) {
        return this.getShapeForState(state);
    }

    @NotNull
    public VoxelShape getShapeForState(BlockState state) {
        if (((Boolean)state.getValue((Property)RAISED)).booleanValue()) {
            return CRShapes.BOILER_RAISED.get((Direction.Axis)state.getValue(HORIZONTAL_AXIS));
        }
        return CRShapes.BOILER.get((Direction.Axis)state.getValue(HORIZONTAL_AXIS));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void customOutline(PoseStack poseStack, VertexConsumer consumer, BlockState state) {
        double offset = (Boolean)state.getValue((Property)RAISED) != false ? 8.0 : 0.0;
        for (int zeroAndOne : Iterate.zeroAndOne) {
            int i = zeroAndOne * 16;
            this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, -8.0, i, -8.0, 1.37258, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 1.37258, i, -8.0, 14.6274, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 14.6274, i, 1.37258, 24.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, 24.0, i, 14.6274, 24.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, 24.0, i, 24.0, 14.6274, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 14.6274, i, 24.0, 1.37258, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 1.37258, i, 14.6274, -8.0, i, offset, Direction.Axis.Y);
            this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, -8.0, i, 1.37258, -8.0, i, offset, Direction.Axis.Y);
        }
        this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, -8.0, 0.0, 1.37258, -8.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 1.37258, 0.0, -8.0, 1.37258, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, -8.0, 14.6274, 0.0, -8.0, 14.6274, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 1.37258, 24.0, 0.0, 1.37258, 24.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, 24.0, 0.0, 14.6274, 24.0, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 14.6274, 0.0, 24.0, 14.6274, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 24.0, 1.37258, 0.0, 24.0, 1.37258, 16.0, offset, Direction.Axis.Y);
        this.drawLineWithAxisOffset(consumer, poseStack, 14.6274, -8.0, 0.0, 14.6274, -8.0, 16.0, offset, Direction.Axis.Y);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void matrixRotation(PoseStack poseStack, BlockState state) {
        if (state.getValue(HORIZONTAL_AXIS) == Direction.Axis.X) {
            poseStack.mulPose(Axis.YP.rotationDegrees(90.0f));
        }
    }

    public static enum Style implements StringRepresentable
    {
        GULLET("boiler_gullet"),
        SMOKEBOX("smokebox_door");

        private final String texture;

        private Style(String texture) {
            this.texture = texture;
        }

        @NotNull
        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }

        public String getTexture() {
            return this.texture;
        }
    }

    @MethodsReturnNonnullByDefault
    private static class PlacementHelper
    extends PoleHelper<Direction.Axis> {
        private PlacementHelper() {
            super(state -> state.getBlock() instanceof BoilerBlock, state -> (Direction.Axis)state.getValue(HORIZONTAL_AXIS), HORIZONTAL_AXIS);
        }

        public Predicate<ItemStack> getItemPredicate() {
            return i -> {
                BlockItem blockItem;
                Item patt0$temp = i.getItem();
                return patt0$temp instanceof BlockItem && (blockItem = (BlockItem)patt0$temp).getBlock() instanceof BoilerBlock;
            };
        }

        public Predicate<BlockState> getStatePredicate() {
            return state -> state.getBlock() instanceof BoilerBlock;
        }

        public PlacementOffset getOffset(Player player, Level level, BlockState state, BlockPos pos, BlockHitResult ray) {
            PlacementOffset offset = PlacementOffset.fail();
            List directions = IPlacementHelper.orderedByDistance((BlockPos)pos, (Vec3)ray.getLocation(), dir -> dir.getAxis() == this.axisFunction.apply(state));
            for (Direction dir2 : directions) {
                BlockPos newPos;
                BlockState newState;
                int poles;
                double extra;
                AttributeInstance reach;
                dir2 = dir2.getOpposite();
                int range = (Integer)AllConfigs.server().equipment.placementAssistRange.get();
                if (player != null && (reach = player.getAttribute(PlacementHelper.getAttribute())) != null && (extra = reach.getValue() - reach.getBaseValue()) > 0.0) {
                    range += (int)Math.round(extra);
                }
                if ((poles = this.attachedPoles(level, pos, dir2)) >= range || !(newState = level.getBlockState(newPos = pos.relative(dir2, poles + 1))).canBeReplaced()) continue;
                offset = PlacementOffset.success((Vec3i)newPos, bState -> (BlockState)bState.setValue(HORIZONTAL_AXIS, (Comparable)((Direction.Axis)state.getValue(HORIZONTAL_AXIS))));
            }
            if (offset.isSuccessful()) {
                offset.withTransform(offset.getTransform().andThen(s -> (BlockState)s.setValue((Property)RAISED, (Comparable)((Boolean)state.getValue((Property)RAISED)))));
            }
            return offset;
        }

        public static Holder<Attribute> getAttribute() {
            return BoilerBlockPlacementHelperImpl.getAttribute();
        }
    }
}

