/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.single_deco;

import com.mojang.serialization.MapCodec;
import com.railwayteam.railways.Railways;
import com.railwayteam.railways.content.buffer.BlockStateBlockItemGroup;
import com.railwayteam.railways.content.buffer.single_deco.AbstractDyeableSingleBufferBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRShapes;
import java.util.Locale;
import javax.annotation.ParametersAreNonnullByDefault;
import net.createmod.catnip.math.VoxelShaper;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class LinkPinBlock
extends AbstractDyeableSingleBufferBlock
implements BlockStateBlockItemGroup.GroupedBlock {
    public static final MapCodec<LinkPinBlock> CODEC = LinkPinBlock.simpleCodec(LinkPinBlock::new);
    public static final EnumProperty<Style> STYLE = EnumProperty.create((String)"style", Style.class);

    public LinkPinBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)this.defaultBlockState().setValue(STYLE, (Comparable)((Object)Style.LINK)));
    }

    protected MapCodec<? extends LinkPinBlock> codec() {
        return CODEC;
    }

    @Override
    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition((StateDefinition.Builder<Block, BlockState>)builder.add(new Property[]{STYLE}));
    }

    @Override
    protected BlockState cycleStyle(BlockState originalState, Direction targetedFace) {
        return (BlockState)originalState.cycle(STYLE);
    }

    @Override
    protected VoxelShaper getShaper(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        return switch (((Style)((Object)state.getValue(STYLE))).ordinal()) {
            default -> throw new MatchException(null, null);
            case 0, 1 -> CRShapes.LINK_PIN;
            case 2, 3 -> CRShapes.KNUCKLE;
            case 4 -> CRShapes.SCREWLINK;
        };
    }

    public ItemStack getCloneItemStack(LevelReader level, BlockPos pos, BlockState state) {
        return CRBlocks.LINK_AND_PIN_GROUP.get((Style)((Object)state.getValue(STYLE))).asStack();
    }

    public static enum Style implements StringRepresentable,
    BlockStateBlockItemGroup.IStyle<Void>
    {
        LINK("link_and_pin", "Link 'n Pin"),
        LINKLESS("link_and_pin_linkless", "Linkless Link 'n Pin"),
        KNUCKLE("knuckle_coupler", "Knuckle Coupler"),
        KNUCKLE_SPLIT("split_knuckle_coupler", "Split Knuckle Coupler"),
        SCREWLINK("screwlink_coupler", "Screwlink Coupler");

        private final String model;
        private final String langName;

        private Style(String model, String langName) {
            this.model = model;
            this.langName = langName;
        }

        public ResourceLocation getModel() {
            return Railways.asResource("block/buffer/single_deco/" + this.model);
        }

        @Override
        public ResourceLocation getModel(Void context) {
            return this.getModel();
        }

        @Override
        public String getBlockId(Void context) {
            return this.model;
        }

        @Override
        public String getLangName(Void context) {
            return this.langName;
        }

        public String getSerializedName() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

