/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer;

import com.railwayteam.railways.content.buffer.BufferBlockPlaceContext;
import com.railwayteam.railways.content.buffer.TrackBufferBlock;
import com.railwayteam.railways.registry.CRBlocks;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.simibubi.create.AllSoundEvents;
import com.simibubi.create.content.trains.graph.EdgePointType;
import com.simibubi.create.content.trains.track.ITrackBlock;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockOutline;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.content.trains.track.TrackTargetingBlockItem;
import com.simibubi.create.foundation.utility.CreateLang;
import com.tterrag.registrate.util.nullness.NonNullBiFunction;
import net.createmod.catnip.data.Pair;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.component.DataComponents;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtUtils;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import org.apache.commons.lang3.mutable.MutableObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TrackBufferBlockItem
extends TrackTargetingBlockItem {
    public static <T extends Block> NonNullBiFunction<? super T, Item.Properties, TrackTargetingBlockItem> ofType(EdgePointType<?> type) {
        return (b, p) -> new TrackBufferBlockItem((Block)b, (Item.Properties)p, type);
    }

    public TrackBufferBlockItem(Block pBlock, Item.Properties pProperties, EdgePointType<?> type) {
        super(pBlock, pProperties, type);
    }

    @Nullable
    protected BlockState getPlacementState(@NotNull BlockPlaceContext context) {
        if (context instanceof BufferBlockPlaceContext) {
            BufferBlockPlaceContext bufferContext = (BufferBlockPlaceContext)context;
            if (bufferContext.overrideBlock != null) {
                BlockState blockState = bufferContext.overrideBlock.getStateForPlacement(context);
                return blockState != null && this.canPlace(context, blockState) ? blockState : null;
            }
        }
        return super.getPlacementState(context);
    }

    private static boolean isOkShape(BlockState state) {
        TrackShape shape = (TrackShape)state.getValue((Property)TrackBlock.SHAPE);
        return switch (shape) {
            case TrackShape.ZO, TrackShape.XO, TrackShape.PD, TrackShape.ND, TrackShape.TE, TrackShape.TN, TrackShape.TS, TrackShape.TW -> true;
            default -> false;
        };
    }

    public InteractionResult useOn(UseOnContext context) {
        ItemStack stack = context.getItemInHand();
        BlockPos pos = context.getClickedPos();
        Level level = context.getLevel();
        BlockState state = level.getBlockState(pos);
        Player player = context.getPlayer();
        if (player == null) {
            return InteractionResult.FAIL;
        }
        Block block = state.getBlock();
        if (block instanceof ITrackBlock) {
            ITrackBlock track = (ITrackBlock)block;
            if (level.isClientSide) {
                return InteractionResult.SUCCESS;
            }
            Vec3 lookAngle = player.getLookAngle();
            Pair nearestTrackAxis = track.getNearestTrackAxis((BlockGetter)level, pos, state, lookAngle);
            boolean front = nearestTrackAxis.getSecond() == Direction.AxisDirection.NEGATIVE;
            Vec3 biasedDirection = ((Vec3)nearestTrackAxis.getFirst()).yRot(10.0f);
            Direction.Axis axis = Direction.getNearest((double)biasedDirection.x, (double)biasedDirection.y, (double)biasedDirection.z).getAxis();
            EdgePointType type = this.getType(stack);
            MutableObject result = new MutableObject(null);
            TrackBufferBlockItem.withGraphLocation((Level)level, (BlockPos)pos, (boolean)front, null, (EdgePointType)type, (overlap, location) -> result.setValue(overlap));
            if (((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback != null) {
                player.displayClientMessage((Component)CreateLang.translateDirect((String)((TrackTargetingBlockItem.OverlapResult)result.getValue()).feedback, (Object[])new Object[0]).withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            if (!TrackBufferBlockItem.isOkShape(state)) {
                player.displayClientMessage((Component)Component.translatable((String)"railways.buffer.invalid_shape").withStyle(ChatFormatting.RED), true);
                AllSoundEvents.DENY.play(level, null, (Vec3i)pos, 0.5f, 1.0f);
                return InteractionResult.FAIL;
            }
            CustomData existing = (CustomData)stack.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY);
            CompoundTag stackTag = existing.copyTag();
            CompoundTag oldTeTag = stackTag.getCompound("BlockEntityTag");
            CompoundTag teTag = new CompoundTag();
            if (oldTeTag != null) {
                if (oldTeTag.contains("Material", 10)) {
                    teTag.put("Material", oldTeTag.get("Material"));
                }
                if (oldTeTag.contains("Color", 3)) {
                    teTag.put("Color", oldTeTag.get("Color"));
                }
            }
            teTag.putBoolean("TargetDirection", front);
            BlockPos placedPos = pos.above();
            Direction placeDirection = Direction.UP;
            TrackBufferBlock overrideBlock = null;
            if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.NARROW_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_NARROW.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.WIDE_GAUGE) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_WIDE.get());
            } else if (track.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
                overrideBlock = (TrackBufferBlock)((Object)CRBlocks.TRACK_BUFFER_MONO.get());
                placedPos = context.getClickedFace() == Direction.DOWN ? pos.below() : pos.above();
                placeDirection = context.getClickedFace();
            }
            teTag.put("TargetTrack", NbtUtils.writeBlockPos((BlockPos)pos.subtract((Vec3i)placedPos)));
            stackTag.put("BlockEntityTag", (Tag)teTag);
            stack.set(DataComponents.CUSTOM_DATA, (Object)CustomData.of((CompoundTag)stackTag));
            TrackShape shape = (TrackShape)state.getValue((Property)TrackBlock.SHAPE);
            boolean diagonal = shape == TrackShape.PD || shape == TrackShape.ND;
            InteractionResult useOn = this.place(BufferBlockPlaceContext.at(new BlockPlaceContext(context), placedPos, placeDirection, Direction.fromAxisAndDirection((Direction.Axis)axis, (Direction.AxisDirection)((Direction.AxisDirection)nearestTrackAxis.getSecond())), overrideBlock, diagonal));
            teTag.remove("TargetTrack");
            teTag.remove("TargetDirection");
            return useOn;
        }
        return InteractionResult.PASS;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean useOnCurve(TrackBlockOutline.BezierPointSelection selection, ItemStack stack) {
        Minecraft mc = Minecraft.getInstance();
        LocalPlayer player = mc.player;
        ClientLevel level = mc.level;
        if (player != null) {
            player.displayClientMessage((Component)CreateLang.translateDirect((String)"track_target.invalid", (Object[])new Object[0]).withStyle(ChatFormatting.RED), true);
            AllSoundEvents.DENY.play((Level)level, (Player)player, player.position(), 0.5f, 1.0f);
            return false;
        }
        return false;
    }
}

